/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pcx;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.pcx.PCXImageWriter;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class PCXImageWriterSpi
extends ImageWriterSpi {
    private static String[] readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.pcx.PCXImageReaderSpi"};
    private static String[] formatNames = new String[]{"pcx", "PCX"};
    private static String[] extensions = new String[]{"pcx"};
    private static String[] mimeTypes = new String[]{"image/pcx", "image/x-pcx", "image/x-windows-pcx", "image/x-pc-paintbrush"};
    private boolean registered = false;

    public PCXImageWriterSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, extensions, mimeTypes, "com.sun.media.imageioimpl.plugins.pcx.PCXImageWriter", STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, null, null, null, null);
    }

    public String getDescription(Locale locale) {
        String string = PackageUtil.getSpecificationTitle() + " PCX Image Writer";
        return string;
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        int n = imageTypeSpecifier.getSampleModel().getDataType();
        if (n < 0 || n > 3) {
            return false;
        }
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        int n2 = sampleModel.getNumBands();
        if (n2 != 1 && n2 != 3) {
            return false;
        }
        if (n2 == 1 && n != 0) {
            return false;
        }
        return n <= 0 || sampleModel instanceof SinglePixelPackedSampleModel;
    }

    public ImageWriter createWriterInstance(Object object) throws IIOException {
        return new PCXImageWriter(this);
    }
}

