/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.math;

import Jama.Matrix;
import java.util.Arrays;
import org.esa.snap.core.util.math.LinearAlgebra;
import org.esa.snap.core.util.math.UnconstrainedLSU;

public class ConstrainedLSU
extends UnconstrainedLSU {
    private final double[] z;
    private final double[] a;

    public ConstrainedLSU(double[][] endmembers) {
        super(endmembers);
        Matrix matrix = new Matrix(endmembers);
        double[][] inverseAtA = matrix.transpose().times(matrix).inverse().getArrayCopy();
        this.z = new double[endmembers[0].length];
        Arrays.fill(this.z, 1.0);
        this.a = LinearAlgebra.multiply(inverseAtA, this.z);
        LinearAlgebra.multiply(this.a, 1.0 / LinearAlgebra.innerProduct(LinearAlgebra.multiply(this.z, inverseAtA), this.z));
    }

    @Override
    public double[][] unmix(double[][] spectra) {
        double[][] abundances = super.unmix(spectra);
        return LinearAlgebra.subtract(abundances, this.a, LinearAlgebra.multiplyAndSubtract(this.z, abundances, 1.0));
    }
}

