/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ProductUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class FeatureUtils {
    public static FeatureCollection<SimpleFeatureType, SimpleFeature> createFeatureCollection(URL url, CoordinateReferenceSystem targetCrs, Geometry clipGeometry) throws IOException {
        FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = FeatureUtils.getFeatureSource(url);
        FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection = featureSource.getFeatures();
        featureCollection = FeatureUtils.clipCollection(featureCollection, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, clipGeometry, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, null, targetCrs, ProgressMonitor.NULL);
        return featureCollection;
    }

    public static FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(URL url) throws IOException {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(ShapefileDataStoreFactory.URLP.key, url);
        map.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.TRUE);
        DataStore shapefileStore = DataStoreFinder.getDataStore(map);
        String typeName = shapefileStore.getTypeNames()[0];
        return shapefileStore.getFeatureSource(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FeatureCollection<SimpleFeatureType, SimpleFeature> loadShapefileForProduct(File file, Product product, FeatureCrsProvider crsProvider, ProgressMonitor pm) throws IOException {
        pm.beginTask("Loading Shapefile", 100);
        try {
            FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection = FeatureUtils.loadFeatureCollectionFromShapefile(file);
            pm.worked(10);
            FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection2 = FeatureUtils.clipFeatureCollectionToProductBounds(featureCollection, product, crsProvider, pm);
            return featureCollection2;
        }
        finally {
            pm.done();
        }
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> clipFeatureCollectionToProductBounds(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection, Product product, FeatureCrsProvider crsProvider, ProgressMonitor pm) {
        CoordinateReferenceSystem targetCrs = product.getSceneCRS();
        Geometry clipGeometry = FeatureUtils.createGeoBoundaryPolygon(product);
        pm.worked(10);
        CoordinateReferenceSystem featureCrs = ((SimpleFeatureType)featureCollection.getSchema()).getCoordinateReferenceSystem();
        if (featureCrs == null) {
            featureCrs = crsProvider.getFeatureCrs(product);
        }
        return FeatureUtils.clipCollection(featureCollection, featureCrs, clipGeometry, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, null, targetCrs, SubProgressMonitor.create((ProgressMonitor)pm, (int)80));
    }

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> loadFeatureCollectionFromShapefile(File shapefile) throws IOException {
        URL shapefileUrl = shapefile.toURI().toURL();
        FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = FeatureUtils.getFeatureSource(shapefileUrl);
        return featureSource.getFeatures();
    }

    public static String createFeatureTypeName(String defaultGeometry) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyyyy'T'HH.mm.ss");
        String currentTime = simpleDateFormat.format(Calendar.getInstance().getTime());
        return String.format("org.esa.snap_%s_%s", defaultGeometry, currentTime);
    }

    public static String createFeatureId(int base) {
        return "ID" + String.format("%08d", base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FeatureCollection<SimpleFeatureType, SimpleFeature> clipCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> sourceCollection, CoordinateReferenceSystem defaultSourceCrs, Geometry clipGeometry, CoordinateReferenceSystem clipCrs, String targetID, CoordinateReferenceSystem targetCrs, ProgressMonitor pm) {
        try {
            GeometryCoordinateSequenceTransformer source2TargetTransformer;
            SimpleFeatureType targetSchema;
            pm.beginTask("Clipping features", sourceCollection.size());
            SimpleFeatureType sourceSchema = (SimpleFeatureType)sourceCollection.getSchema();
            Map userData = sourceSchema.getUserData();
            CoordinateReferenceSystem sourceCrs = sourceSchema.getCoordinateReferenceSystem();
            if (targetID == null || targetID.isEmpty()) {
                targetID = sourceCollection.getID();
            }
            if (sourceCrs == null) {
                sourceCrs = defaultSourceCrs;
            }
            if (sourceCrs == null) {
                throw new IllegalStateException("'sourceCollection' has no CRS defined and 'defaultSourceCrs' is null");
            }
            try {
                sourceSchema = FeatureTypes.transform((SimpleFeatureType)sourceSchema, (CoordinateReferenceSystem)sourceCrs);
            }
            catch (SchemaException e) {
                throw new IllegalStateException(e);
            }
            if (targetCrs == null) {
                targetCrs = sourceCrs;
            }
            try {
                GeometryCoordinateSequenceTransformer clip2SourceTransformer = FeatureUtils.getTransform(clipCrs, sourceCrs);
                clipGeometry = clip2SourceTransformer.transform(clipGeometry);
            }
            catch (TransformException e) {
                throw new IllegalStateException(e);
            }
            try {
                targetSchema = FeatureTypes.transform((SimpleFeatureType)sourceSchema, (CoordinateReferenceSystem)targetCrs);
                targetSchema.getUserData().putAll(userData);
                source2TargetTransformer = FeatureUtils.getTransform(sourceCrs, targetCrs);
            }
            catch (SchemaException e) {
                throw new IllegalStateException(e);
            }
            DefaultFeatureCollection targetCollection = new DefaultFeatureCollection(targetID, targetSchema);
            try (FeatureIterator features = sourceCollection.features();){
                while (features.hasNext()) {
                    SimpleFeature targetFeature;
                    Geometry clippedSourceGeometry;
                    SimpleFeature sourceFeature = (SimpleFeature)features.next();
                    pm.worked(1);
                    try {
                        Geometry sourceGeometry = (Geometry)sourceFeature.getDefaultGeometry();
                        clippedSourceGeometry = FeatureUtils.getClippedGeometry(sourceGeometry, clipGeometry);
                    }
                    catch (TopologyException ignored) {
                        continue;
                    }
                    if (clippedSourceGeometry.isEmpty() || (targetFeature = FeatureUtils.createTargetFeature(clippedSourceGeometry, targetSchema, sourceFeature, source2TargetTransformer)) == null) continue;
                    targetCollection.add(targetFeature);
                }
            }
            DefaultFeatureCollection defaultFeatureCollection = targetCollection;
            return defaultFeatureCollection;
        }
        finally {
            pm.done();
        }
    }

    private static SimpleFeature createTargetFeature(Geometry sourceGeometry, SimpleFeatureType targetSchema, SimpleFeature sourceFeature, GeometryCoordinateSequenceTransformer source2TargetTransformer) {
        SimpleFeature targetFeature;
        if (source2TargetTransformer != null) {
            Geometry targetGeometry;
            try {
                targetGeometry = source2TargetTransformer.transform(sourceGeometry);
            }
            catch (Exception e) {
                Debug.trace(e);
                return null;
            }
            targetFeature = SimpleFeatureBuilder.retype((SimpleFeature)sourceFeature, (SimpleFeatureType)targetSchema);
            targetFeature.setDefaultGeometry((Object)targetGeometry);
        } else {
            targetFeature = SimpleFeatureBuilder.copy((SimpleFeature)sourceFeature);
            targetFeature.setDefaultGeometry((Object)sourceGeometry);
        }
        return targetFeature;
    }

    private static Geometry getClippedGeometry(Geometry sourceGeometry, Geometry clipGeometry) {
        Geometry targetGeometry = sourceGeometry.intersection(clipGeometry);
        if (targetGeometry instanceof Polygon) {
            GeometryFactory geometryFactory = new GeometryFactory();
            if (MultiPolygon.class.isAssignableFrom(sourceGeometry.getClass())) {
                targetGeometry = geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)targetGeometry});
            }
        }
        return targetGeometry;
    }

    public static GeometryCoordinateSequenceTransformer getTransform(CoordinateReferenceSystem sourceCrs, CoordinateReferenceSystem targetCrs) {
        GeometryCoordinateSequenceTransformer transformer;
        try {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCrs, (CoordinateReferenceSystem)targetCrs, (boolean)true);
            transformer = new GeometryCoordinateSequenceTransformer();
            transformer.setMathTransform(transform);
            transformer.setCoordinateReferenceSystem(targetCrs);
        }
        catch (FactoryException e) {
            throw new IllegalStateException(e);
        }
        return transformer;
    }

    public static Geometry createGeoBoundaryPolygon(Product product) {
        Coordinate[] coordinates;
        GeometryFactory gf = new GeometryFactory();
        GeoPos[] geoPositions = ProductUtils.createGeoBoundary(product, 100);
        if (geoPositions.length >= 0 && geoPositions.length <= 3) {
            coordinates = new Coordinate[]{};
        } else {
            coordinates = new Coordinate[geoPositions.length + 1];
            for (int i = 0; i < geoPositions.length; ++i) {
                GeoPos geoPos = geoPositions[i];
                coordinates[i] = new Coordinate(geoPos.lon, geoPos.lat);
            }
            coordinates[coordinates.length - 1] = coordinates[0];
        }
        return gf.createPolygon(gf.createLinearRing(coordinates), null);
    }

    public static interface FeatureCrsProvider {
        public CoordinateReferenceSystem getFeatureCrs(Product var1);

        public boolean clipToProductBounds();
    }
}

