/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.param.validators;

import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.jexp.EvalEnv;
import org.esa.snap.core.jexp.EvalException;
import org.esa.snap.core.jexp.Function;
import org.esa.snap.core.jexp.Namespace;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Parser;
import org.esa.snap.core.jexp.Symbol;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.impl.AbstractFunction;
import org.esa.snap.core.jexp.impl.AbstractSymbol;
import org.esa.snap.core.jexp.impl.DefaultNamespace;
import org.esa.snap.core.jexp.impl.ParserImpl;
import org.esa.snap.core.param.ParamParseException;
import org.esa.snap.core.param.ParamProperties;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.core.param.validators.StringValidator;
import org.esa.snap.core.util.Debug;

public abstract class AbstractExpressionValidator
extends StringValidator {
    public static final String PROPERTY_KEY_SELECTED_PRODUCT = "selectedProduct";
    public static final String PROPERTY_KEY_INPUT_PRODUCTS = "inputProducts";
    public static final String PROPERTY_KEY_PREFERENCES = "preferences";

    protected AbstractExpressionValidator() {
    }

    @Override
    public Object parse(Parameter parameter, String text) throws ParamParseException {
        Debug.assertTrue(text != null);
        if (AbstractExpressionValidator.isAllowedNullText(parameter, text)) {
            return null;
        }
        Parser parser = this.getParser(parameter);
        try {
            parser.parse(text);
        }
        catch (ParseException e) {
            throw new ParamParseException(parameter, e.getMessage());
        }
        return text;
    }

    @Override
    public boolean equalValues(Parameter parameter, Object value1, Object value2) {
        return AbstractExpressionValidator.equalValues(false, value1, value2);
    }

    private Parser getParser(Parameter parameter) {
        Parser parser;
        ParamProperties properties = parameter.getProperties();
        Object propertyValue = properties.getPropertyValue(PROPERTY_KEY_SELECTED_PRODUCT);
        if (propertyValue instanceof Product) {
            Product product = (Product)((Object)propertyValue);
            parser = product.createBandArithmeticParser();
        } else {
            parser = this.createFallbackParser();
        }
        return parser;
    }

    private ParserImpl createFallbackParser() {
        DummyNamespace fallbackNS = new DummyNamespace();
        DefaultNamespace defaultNS = new DefaultNamespace(fallbackNS);
        return new ParserImpl(defaultNS, false);
    }

    private static class DummyFunction
    extends AbstractFunction.D {
        public DummyFunction(String name, Term[] args) {
            super(name, args.length);
        }

        @Override
        public double evalD(EvalEnv env, Term[] args) throws EvalException {
            return 0.0;
        }
    }

    private static class DummySymbol
    extends AbstractSymbol {
        public DummySymbol(String name) {
            super(name, 3);
        }

        @Override
        public boolean evalB(EvalEnv env) throws EvalException {
            return false;
        }

        @Override
        public int evalI(EvalEnv env) throws EvalException {
            return 0;
        }

        @Override
        public double evalD(EvalEnv env) throws EvalException {
            return 0.0;
        }

        @Override
        public String evalS(EvalEnv env) throws EvalException {
            return "0";
        }
    }

    private static class DummyNamespace
    implements Namespace {
        private DummyNamespace() {
        }

        @Override
        public Symbol resolveSymbol(String name) {
            return new DummySymbol(name);
        }

        @Override
        public Function resolveFunction(String name, Term[] args) {
            return new DummyFunction(name, args);
        }
    }
}

