/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import com.bc.ceres.core.Assert;
import com.bc.ceres.jai.NoDataRaster;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.dataop.barithm.RasterDataEvalEnv;
import org.esa.snap.core.dataop.barithm.RasterDataSymbol;
import org.esa.snap.core.dataop.barithm.RasterDataSymbolReplacer;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.SingleBandedOpImage;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.impl.TermDecompiler;
import org.esa.snap.core.util.ImageUtils;

public class VirtualBandOpImage
extends SingleBandedOpImage {
    private static final int TRUE = 255;
    private static final int FALSE = 0;
    private final Term term;
    private final int dataType;
    private final Number fillValue;
    private final boolean mask;
    private final Map<Point, Term> effectiveTerms = new ConcurrentHashMap<Point, Term>();
    private volatile NoDataRaster noDataRaster;

    public static Builder builder(Term term) {
        return new Builder(term);
    }

    public static Builder builder(String expression, Product source) {
        return VirtualBandOpImage.builder(expression, 0, source);
    }

    public static Builder builder(String expression, int contextSourceIndex, Product ... sources) {
        Term term = VirtualBandOpImage.parseExpression(expression, contextSourceIndex, sources);
        Product contextSource = sources[contextSourceIndex];
        Dimension sourceSize = new Dimension(contextSource.getSceneRasterWidth(), contextSource.getSceneRasterHeight());
        Dimension tileSize = contextSource.getPreferredTileSize();
        return new Builder(term).sourceSize(sourceSize).tileSize(tileSize);
    }

    public static Term parseExpression(String expression, Product source) {
        int contextSourceIndex;
        Product[] sources;
        if (source.getProductManager() != null) {
            sources = source.getProductManager().getProducts();
            contextSourceIndex = source.getProductManager().getProductIndex(source);
        } else {
            sources = new Product[]{source};
            contextSourceIndex = 0;
        }
        return VirtualBandOpImage.parseExpression(expression, contextSourceIndex, sources);
    }

    public static Term parseExpression(String expression, int contextSourceIndex, Product ... sources) {
        Assert.notNull((Object)expression, (String)"expression");
        Assert.argument((!expression.trim().isEmpty() ? 1 : 0) != 0, (String)"!expression.trim().isEmpty()");
        Assert.argument((contextSourceIndex >= 0 ? 1 : 0) != 0, (String)"contextSourceIndex >= 0");
        Assert.argument((sources.length > 0 ? 1 : 0) != 0, (String)"sources.length > 0");
        for (int i = 0; i < sources.length; ++i) {
            Assert.argument((sources[i] != null ? 1 : 0) != 0, (String)("sources[" + i + "] != null"));
        }
        try {
            return BandArithmetic.parseExpression(expression, sources, contextSourceIndex);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("expression: " + e.getMessage(), e);
        }
    }

    private VirtualBandOpImage(Term term, int dataType, Number fillValue, boolean mask, int sourceWidth, int sourceHeight, Dimension tileSize, Map imageConfig, ResolutionLevel level) {
        super(ImageManager.getDataBufferType(dataType), sourceWidth, sourceHeight, tileSize, imageConfig, level);
        this.term = term;
        this.dataType = dataType;
        this.mask = mask;
        this.fillValue = fillValue;
    }

    public int getDataType() {
        return this.dataType;
    }

    public boolean isMask() {
        return this.mask;
    }

    public String getExpression() {
        return new TermDecompiler().decompile(this.term);
    }

    public synchronized void dispose() {
        this.effectiveTerms.clear();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster computeTile(int tileX, int tileY) {
        Term effectiveTerm = new RasterDataSymbolReplacer().apply(this.term);
        if (this.addDataToReferredRasterDataSymbols(this.getTileRect(tileX, tileY), effectiveTerm)) {
            this.effectiveTerms.put(new Point(tileX, tileY), effectiveTerm);
            return super.computeTile(tileX, tileY);
        }
        if (this.noDataRaster == null) {
            VirtualBandOpImage virtualBandOpImage = this;
            synchronized (virtualBandOpImage) {
                if (this.noDataRaster == null) {
                    this.noDataRaster = this.createNoDataRaster(this.fillValue == null ? 0.0 : this.fillValue.doubleValue());
                }
            }
        }
        return this.noDataRaster.createTranslatedChild(this.tileXToX(tileX), this.tileYToY(tileY));
    }

    protected void computeRect(PlanarImage[] planarImages, WritableRaster writableRaster, Rectangle destRect) {
        Term effectiveTerm = this.effectiveTerms.remove(this.getTileIndices(destRect)[0]);
        ProductData productData = ProductData.createInstance(this.dataType, ImageUtils.getPrimitiveArray(writableRaster.getDataBuffer()));
        int x = destRect.x - writableRaster.getMinX();
        int y = destRect.y - writableRaster.getMinY();
        int w = writableRaster.getWidth();
        int colCount = destRect.width;
        int rowCount = destRect.height;
        int pixelCount = colCount * rowCount;
        RasterDataEvalEnv env = new RasterDataEvalEnv(destRect.x, destRect.y, colCount, rowCount, this.getLevelImageSupport());
        if (this.mask) {
            int i = 0;
            int k = w * y;
            while (i < pixelCount) {
                int j = 0;
                int l = x;
                while (j < colCount) {
                    env.setElemIndex(i + j);
                    productData.setElemUIntAt(k + l, effectiveTerm.evalB(env) ? 255L : 0L);
                    ++j;
                    ++l;
                }
                i += colCount;
                k += w;
            }
        } else if (this.fillValue != null) {
            double fv = this.fillValue.doubleValue();
            int i = 0;
            int k = w * y;
            while (i < pixelCount) {
                int j = 0;
                int l = x;
                while (j < colCount) {
                    env.setElemIndex(i + j);
                    double v = effectiveTerm.evalD(env);
                    if (Double.isNaN(v) || Double.isInfinite(v)) {
                        productData.setElemDoubleAt(k + l, fv);
                    } else {
                        productData.setElemDoubleAt(k + l, v);
                    }
                    ++j;
                    ++l;
                }
                i += colCount;
                k += w;
            }
        } else {
            int i = 0;
            int k = w * y;
            while (i < pixelCount) {
                int j = 0;
                int l = x;
                while (j < colCount) {
                    env.setElemIndex(i + j);
                    productData.setElemDoubleAt(k + l, effectiveTerm.evalD(env));
                    ++j;
                    ++l;
                }
                i += colCount;
                k += w;
            }
        }
    }

    private boolean addDataToReferredRasterDataSymbols(Rectangle destRect, Term term) {
        for (RasterDataSymbol symbol : BandArithmetic.getRefRasterDataSymbols(term)) {
            int dataType;
            PlanarImage sourceImage;
            RasterDataNode rasterDataNode = symbol.getRaster();
            if (symbol.getSource() == RasterDataSymbol.GEOPHYSICAL) {
                sourceImage = ImageManager.getInstance().getGeophysicalImage(rasterDataNode, this.getLevel());
                dataType = rasterDataNode.getGeophysicalDataType();
            } else {
                sourceImage = ImageManager.getInstance().getSourceImage(rasterDataNode, this.getLevel());
                dataType = rasterDataNode.getDataType();
            }
            Raster sourceRaster = sourceImage.getData(destRect);
            if (sourceRaster instanceof NoDataRaster) {
                return false;
            }
            DataBuffer dataBuffer = sourceRaster.getDataBuffer();
            if (dataBuffer.getSize() != destRect.width * destRect.height) {
                WritableRaster writableRaster = sourceRaster.createCompatibleWritableRaster(destRect);
                sourceImage.copyData(writableRaster);
                dataBuffer = writableRaster.getDataBuffer();
            }
            symbol.setData(ProductData.createInstance(dataType, ImageUtils.getPrimitiveArray(dataBuffer)));
        }
        return true;
    }

    public static class Builder {
        private final Term term;
        private Integer dataType;
        private Number fillValue;
        private Boolean mask;
        private Dimension sourceSize;
        private Dimension tileSize;
        private Map imageConfig;
        private ResolutionLevel level;

        protected Builder(Term term) {
            Assert.notNull((Object)term, (String)"term");
            this.term = term;
        }

        public Builder dataType(int dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder fillValue(Number fillValue) {
            this.fillValue = fillValue;
            return this;
        }

        public Builder mask(boolean mask) {
            this.mask = mask;
            return this;
        }

        public Builder sourceSize(Dimension sourceSize) {
            Assert.notNull((Object)sourceSize, (String)"sourceSize");
            this.sourceSize = sourceSize;
            return this;
        }

        public Builder tileSize(Dimension tileSize) {
            this.tileSize = tileSize;
            return this;
        }

        public Builder imageConfig(Map imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        public Builder level(ResolutionLevel level) {
            this.level = level;
            return this;
        }

        public VirtualBandOpImage create() {
            boolean mask;
            Assert.state((this.sourceSize != null ? 1 : 0) != 0, (String)"sourceSize != null");
            if (Boolean.TRUE.equals(this.mask) && this.dataType != null) {
                Assert.state((boolean)this.dataType.equals(20), (String)"dataType.equals(ProductData.TYPE_UINT8)");
            }
            boolean bl = mask = this.mask != null ? this.mask : false;
            int dataType = this.dataType != null ? this.dataType : (mask ? 20 : 30);
            ResolutionLevel level = this.level != null ? this.level : ResolutionLevel.MAXRES;
            return new VirtualBandOpImage(this.term, dataType, this.fillValue, mask, this.sourceSize.width, this.sourceSize.height, this.tileSize, this.imageConfig, level);
        }
    }
}

