/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Date;
import java.util.List;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PinDescriptor;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlainFeatureFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ObjectUtils;
import org.esa.snap.runtime.Config;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class Placemark
extends ProductNode {
    public static final String PREFERENCE_KEY_ADJUST_PIN_GEO_POS = "snap.adjustPinGeoPos";
    public static final String PROPERTY_NAME_LABEL = "label";
    public static final String PROPERTY_NAME_TEXT = "text";
    public static final String PROPERTY_NAME_PIXELPOS = "pixelPos";
    public static final String PROPERTY_NAME_GEOPOS = "geoPos";
    public static final String PROPERTY_NAME_DATETIME = "dateTime";
    public static final String PROPERTY_NAME_STYLE_CSS = "style_css";
    private final PlacemarkDescriptor descriptor;
    private final SimpleFeature feature;

    public static Placemark createPointPlacemark(PlacemarkDescriptor descriptor, String name, String label, String text, PixelPos pixelPos, GeoPos geoPos, GeoCoding geoCoding) {
        SimpleFeature pointFeature = Placemark.createPointFeature(descriptor, name, label, text, pixelPos, geoPos, geoCoding);
        return new Placemark(descriptor, pointFeature);
    }

    public Placemark(PlacemarkDescriptor descriptor, SimpleFeature feature) {
        super(feature.getID(), Placemark.getStringAttribute(feature, PROPERTY_NAME_TEXT));
        this.descriptor = descriptor;
        this.feature = feature;
        Debug.trace("Placemark created: descriptor=" + descriptor.getClass() + ", featureType=" + feature.getFeatureType().getTypeName() + ", feature=" + feature);
    }

    public PlacemarkDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final SimpleFeature getFeature() {
        return this.feature;
    }

    public Object getAttributeValue(String attributeName) {
        return this.feature.getAttribute(attributeName);
    }

    public void setAttributeValue(String attributeName, Object attributeValue) {
        int index = this.feature.getFeatureType().indexOf(attributeName);
        if (index != -1 && !ObjectUtils.equalObjects(attributeValue, this.getAttributeValue(attributeName))) {
            this.feature.setAttribute(index, attributeValue);
            this.fireProductNodeChanged(attributeName);
        }
    }

    public void setLabel(String label) {
        this.setAttributeValue(PROPERTY_NAME_LABEL, label != null ? label : "");
    }

    public String getLabel() {
        return (String)this.getAttributeValue(PROPERTY_NAME_LABEL);
    }

    public void setText(String text) {
        this.setAttributeValue(PROPERTY_NAME_TEXT, text != null ? text : "");
    }

    public String getText() {
        return Placemark.getStringAttribute(this.feature, PROPERTY_NAME_TEXT);
    }

    public void setStyleCss(String styleCss) {
        this.setAttributeValue(PROPERTY_NAME_STYLE_CSS, styleCss != null ? styleCss : "");
    }

    public String getStyleCss() {
        return Placemark.getStringAttribute(this.feature, PROPERTY_NAME_STYLE_CSS);
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        return 256L;
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
    }

    public PixelPos getPixelPos() {
        return Placemark.toPixelPos(this.getPixelPosAttribute());
    }

    public void setPixelPos(PixelPos pixelPos) {
        this.setPixelPosAttribute(pixelPos, true, true);
    }

    public GeoPos getGeoPos() {
        return Placemark.toGeoPos(this.getGeoPosAttribute());
    }

    public void setGeoPos(GeoPos geoPos) {
        this.setGeoPosAttribute(geoPos, true);
    }

    public void updatePositions() {
        Object defaultGeometry = this.feature.getDefaultGeometry();
        if (defaultGeometry instanceof Point) {
            Point point = (Point)defaultGeometry;
            if (this.getProduct() != null) {
                GeoCoding geoCoding = this.getProduct().getSceneGeoCoding();
                AffineTransform i2m = Product.findImageToModelTransform(geoCoding);
                PixelPos pixelPos = new PixelPos(point.getX(), point.getY());
                try {
                    i2m.inverseTransform(pixelPos, pixelPos);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
                this.setPixelPosAttribute(pixelPos, true, false);
            }
        }
    }

    private Coordinate getPixelPosAttribute() {
        Point point = (Point)this.getAttributeValue(PROPERTY_NAME_PIXELPOS);
        if (point != null) {
            return point.getCoordinate();
        }
        return null;
    }

    private void setPixelPosAttribute(PixelPos pixelPos, boolean updateGeoPos, boolean updateDefaultGeometry) {
        Coordinate newCoordinate = Placemark.toCoordinate(pixelPos);
        Coordinate oldCoordinate = this.getPixelPosAttribute();
        if (!ObjectUtils.equalObjects(oldCoordinate, newCoordinate)) {
            if (oldCoordinate == null) {
                GeometryFactory geometryFactory = new GeometryFactory();
                this.setAttributeValue(PROPERTY_NAME_PIXELPOS, geometryFactory.createPoint(newCoordinate));
            } else {
                Point point = (Point)this.getAttributeValue(PROPERTY_NAME_PIXELPOS);
                point.getCoordinate().setCoordinate(newCoordinate);
                point.geometryChanged();
            }
            if (updateDefaultGeometry) {
                this.updateDefaultGeometryAttribute(pixelPos);
            }
            if (updateGeoPos && this.getProduct() != null) {
                GeoPos geoPos = this.getGeoPos();
                this.descriptor.updateGeoPos(this.getProduct().getSceneGeoCoding(), pixelPos, geoPos);
                this.setGeoPosAttribute(geoPos, false);
            }
            this.fireProductNodeChanged(PROPERTY_NAME_PIXELPOS);
        }
    }

    private Coordinate getGeoPosAttribute() {
        Point point = (Point)this.getAttributeValue(PROPERTY_NAME_GEOPOS);
        if (point != null) {
            return point.getCoordinate();
        }
        return null;
    }

    private void setGeoPosAttribute(GeoPos geoPos, boolean updatePixelPos) {
        Coordinate newCoordinate = Placemark.toCoordinate(geoPos);
        Coordinate oldCoordinate = this.getGeoPosAttribute();
        if (!ObjectUtils.equalObjects(oldCoordinate, newCoordinate)) {
            if (oldCoordinate == null) {
                GeometryFactory geometryFactory = new GeometryFactory();
                this.setAttributeValue(PROPERTY_NAME_GEOPOS, geometryFactory.createPoint(newCoordinate));
            } else if (newCoordinate != null) {
                Point point = (Point)this.getAttributeValue(PROPERTY_NAME_GEOPOS);
                point.getCoordinate().setCoordinate(newCoordinate);
                point.geometryChanged();
            }
            if (updatePixelPos && this.getProduct() != null) {
                PixelPos pixelPos = this.getPixelPos();
                this.descriptor.updatePixelPos(this.getProduct().getSceneGeoCoding(), geoPos, pixelPos);
                this.setPixelPosAttribute(pixelPos, false, true);
            }
            this.fireProductNodeChanged(PROPERTY_NAME_GEOPOS);
        }
    }

    private void updateDefaultGeometryAttribute(PixelPos pixelPos) {
        Product product = this.getProduct();
        Point2D.Double geometryPoint = new Point2D.Double(pixelPos.x, pixelPos.y);
        if (product != null) {
            AffineTransform i2m = Product.findImageToModelTransform(product.getSceneGeoCoding());
            i2m.transform(pixelPos, geometryPoint);
        }
        Point point = (Point)this.feature.getDefaultGeometry();
        point.getCoordinate().setCoordinate(Placemark.toCoordinate(geometryPoint));
        point.geometryChanged();
    }

    private static SimpleFeature createPointFeature(PlacemarkDescriptor descriptor, String name, String label, String text, PixelPos pixelPos, GeoPos geoPos, GeoCoding geoCoding) {
        if (pixelPos == null && geoPos == null) {
            throw new IllegalArgumentException("pixelPos == null && geoPos == null");
        }
        GeometryFactory geometryFactory = new GeometryFactory();
        PixelPos imagePos = pixelPos;
        if ((descriptor instanceof PinDescriptor || imagePos == null) && geoPos != null && geoCoding != null && geoCoding.canGetPixelPos()) {
            imagePos = geoCoding.getPixelPos(geoPos, imagePos);
        }
        if (imagePos == null) {
            imagePos = new PixelPos();
            imagePos.setInvalid();
        }
        Point2D scenePos = Product.findImageToModelTransform(geoCoding).transform(imagePos, new Point2D.Double());
        Point geometry = geometryFactory.createPoint(Placemark.toCoordinate(scenePos));
        SimpleFeature feature = PlainFeatureFactory.createPlainFeature(descriptor.getBaseFeatureType(), name, (Geometry)geometry, null);
        feature.setAttribute(PROPERTY_NAME_PIXELPOS, (Object)geometryFactory.createPoint(Placemark.toCoordinate(imagePos)));
        if (geoPos == null) {
            if (geoCoding != null && geoCoding.canGetGeoPos()) {
                geoPos = geoCoding.getGeoPos(imagePos, geoPos);
            }
        } else if (Config.instance().preferences().getBoolean(PREFERENCE_KEY_ADJUST_PIN_GEO_POS, true)) {
            descriptor.updateGeoPos(geoCoding, imagePos, geoPos);
        }
        if (geoPos != null) {
            feature.setAttribute(PROPERTY_NAME_GEOPOS, (Object)geometryFactory.createPoint(Placemark.toCoordinate(geoPos)));
        }
        feature.setAttribute(PROPERTY_NAME_LABEL, (Object)(label != null ? label : ""));
        feature.setAttribute(PROPERTY_NAME_TEXT, (Object)(text != null ? text : ""));
        return feature;
    }

    private static Coordinate toCoordinate(GeoPos geoPos) {
        if (geoPos != null) {
            return new Coordinate(geoPos.getLon(), geoPos.getLat());
        }
        return null;
    }

    private static Coordinate toCoordinate(Point2D pixelPos) {
        if (pixelPos != null) {
            return new Coordinate(pixelPos.getX(), pixelPos.getY());
        }
        return null;
    }

    private static GeoPos toGeoPos(Coordinate coordinate) {
        if (coordinate != null) {
            return new GeoPos(coordinate.y, coordinate.x);
        }
        return null;
    }

    private static PixelPos toPixelPos(Coordinate coordinate) {
        if (coordinate != null) {
            return new PixelPos(coordinate.x, coordinate.y);
        }
        return null;
    }

    public static SimpleFeatureType createPinFeatureType() {
        return Placemark.createPointFeatureType("org.esa.snap.Pin");
    }

    public static SimpleFeatureType createGcpFeatureType() {
        return Placemark.createPointFeatureType("org.esa.snap.GroundControlPoint");
    }

    public static SimpleFeatureType createGeometryFeatureType() {
        return PlainFeatureFactory.createDefaultFeatureType();
    }

    public static SimpleFeatureType createPointFeatureType(String name) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        SimpleFeatureType superType = PlainFeatureFactory.createPlainFeatureType(name, Point.class, null);
        List list = superType.getAttributeDescriptors();
        for (AttributeDescriptor descriptor : list) {
            builder.add(descriptor);
        }
        builder.setName(name);
        builder.add(PROPERTY_NAME_LABEL, String.class);
        builder.add(PROPERTY_NAME_TEXT, String.class);
        builder.add(PROPERTY_NAME_PIXELPOS, Point.class);
        builder.add(PROPERTY_NAME_GEOPOS, Point.class);
        builder.add(PROPERTY_NAME_DATETIME, Date.class);
        return builder.buildFeatureType();
    }

    private static String getStringAttribute(SimpleFeature feature, String attributeName) {
        Object attribute = feature.getAttribute(attributeName);
        if (attribute != null) {
            return attribute.toString();
        }
        return "";
    }
}

