/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.rgb;

import java.io.File;
import java.util.Locale;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.rgb.ImageProductReader;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;

public class ImageProductReaderPlugIn
implements ProductReaderPlugIn {
    public static final String FORMAT_NAME = "IMAGE";

    @Override
    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    @Override
    public String[] getDefaultFileExtensions() {
        return new String[]{".png", ".gif", ".jpg", ".bmp", ".pnm", ".pbm", ".pgm", ".ppm"};
    }

    @Override
    public String getDescription(Locale name) {
        return "Image product reader";
    }

    @Override
    public DecodeQualification getDecodeQualification(Object object) {
        String fileExt;
        File file = ImageProductReaderPlugIn.getFile(object);
        if (file != null && (fileExt = FileUtils.getExtension(file)) != null && StringUtils.contains(this.getDefaultFileExtensions(), fileExt.toLowerCase())) {
            return DecodeQualification.SUITABLE;
        }
        return DecodeQualification.UNABLE;
    }

    static File getFile(Object object) {
        File file = null;
        if (object instanceof String) {
            file = new File((String)object);
        } else if (object instanceof File) {
            file = (File)object;
        }
        return file;
    }

    @Override
    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public ProductReader createReaderInstance() {
        return new ImageProductReader(this);
    }

    @Override
    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(FORMAT_NAME, this.getDefaultFileExtensions(), "Image files");
    }
}

