/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio;

import java.io.IOException;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.Guardian;

public abstract class AbstractProductWriter
implements ProductWriter {
    private final ProductWriterPlugIn _writerPlugIn;
    private Product _sourceProduct;
    private Object _output;

    public AbstractProductWriter(ProductWriterPlugIn writerPlugIn) {
        Guardian.assertNotNull("writerPlugIn", writerPlugIn);
        this._writerPlugIn = writerPlugIn;
    }

    @Override
    public ProductWriterPlugIn getWriterPlugIn() {
        return this._writerPlugIn;
    }

    protected Product getSourceProduct() {
        return this._sourceProduct;
    }

    @Override
    public Object getOutput() {
        return this._output;
    }

    @Override
    public void writeProductNodes(Product product, Object output) throws IOException {
        Guardian.assertNotNull("product", (Object)product);
        Guardian.assertNotNull("output", output);
        if (!this.isInstanceOfValidOutputType(output)) {
            throw new IllegalArgumentException("invalid output type");
        }
        this._sourceProduct = product;
        this._output = output;
        this.writeProductNodesImpl();
        this._sourceProduct.setModified(false);
    }

    protected abstract void writeProductNodesImpl() throws IOException;

    protected void checkOutput() throws IllegalStateException {
        if (this._output == null) {
            throw new IllegalStateException("output not set");
        }
    }

    protected boolean isInstanceOfValidOutputType(Object output) {
        Class[] outputTypes;
        for (Class outputType : outputTypes = this.getWriterPlugIn().getOutputTypes()) {
            if (!outputType.isInstance(output)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldWrite(ProductNode node) {
        return true;
    }

    @Override
    public void setIncrementalMode(boolean enabled) {
    }

    @Override
    public boolean isIncrementalMode() {
        return false;
    }

    @Override
    public void removeBand(Band band) {
    }

    @Override
    public void setFormatName(String formatName) {
    }
}

