/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.util.ArrayList;
import org.esa.snap.binning.Aggregator;

public abstract class AbstractAggregator
implements Aggregator {
    private final String name;
    private final String[] spatialFeatureNames;
    private final String[] temporalFeatureNames;
    private final String[] outputFeatureNames;

    protected AbstractAggregator(String name, String[] spatialFeatureNames, String[] temporalFeatureNames, String[] outputFeatureNames) {
        this.name = name;
        this.spatialFeatureNames = spatialFeatureNames;
        this.temporalFeatureNames = temporalFeatureNames;
        this.outputFeatureNames = outputFeatureNames;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getSpatialFeatureNames() {
        return this.spatialFeatureNames;
    }

    @Override
    public String[] getTemporalFeatureNames() {
        return this.temporalFeatureNames;
    }

    @Override
    public String[] getOutputFeatureNames() {
        return this.outputFeatureNames;
    }

    public static String[] createFeatureNames(String varName, String ... postfixes) {
        ArrayList<String> featureNames = new ArrayList<String>(postfixes.length);
        for (String postfix : postfixes) {
            if (postfix == null) continue;
            featureNames.add(varName + "_" + postfix);
        }
        return featureNames.toArray(new String[featureNames.size()]);
    }
}

