/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.model;

import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.rcp.SnapApp;

public class ProductLibraryConfig {
    private static final String WINDOW_LOCATION_X_KEY = "productLibrary.window.locationX";
    private static final String WINDOW_LOCATION_Y_KEY = "productLibrary.window.locationY";
    private static final String WINDOW_WIDTH_KEY = "productLibrary.window.width";
    private static final String WINDOW_HEIGHT_KEY = "productLibrary.window.height";
    private static final String BASE_DIR = "productLibrary.baseDir_";
    private final Preferences pref;

    public ProductLibraryConfig(Preferences preferences) {
        Guardian.assertNotNull((String)"preferences", (Object)preferences);
        this.pref = preferences;
    }

    public void addBaseDir(File baseDir) {
        this.pref.put(BASE_DIR + baseDir.getAbsolutePath(), baseDir.getAbsolutePath());
    }

    public void removeBaseDir(File baseDir) {
        this.pref.remove(BASE_DIR + baseDir.getAbsolutePath());
    }

    public File[] getBaseDirs() {
        ArrayList<File> dirList = new ArrayList<File>();
        try {
            for (String key : this.pref.keys()) {
                File file;
                String path;
                if (!key.startsWith(BASE_DIR) || (path = this.pref.get(key, null)) == null || !(file = new File(path)).exists()) continue;
                dirList.add(file);
            }
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Product Library unable to reload base folders", (Throwable)e);
        }
        return dirList.toArray(new File[dirList.size()]);
    }

    public void setWindowBounds(Rectangle windowBounds) {
        this.pref.put(WINDOW_LOCATION_X_KEY, String.valueOf(windowBounds.x));
        this.pref.put(WINDOW_LOCATION_Y_KEY, String.valueOf(windowBounds.y));
        this.pref.put(WINDOW_WIDTH_KEY, String.valueOf(windowBounds.width));
        this.pref.put(WINDOW_HEIGHT_KEY, String.valueOf(windowBounds.height));
    }

    public Rectangle getWindowBounds() {
        int x = Integer.parseInt(this.pref.get(WINDOW_LOCATION_X_KEY, "50"));
        int y = Integer.parseInt(this.pref.get(WINDOW_LOCATION_Y_KEY, "50"));
        int width = Integer.parseInt(this.pref.get(WINDOW_WIDTH_KEY, "700"));
        int height = Integer.parseInt(this.pref.get(WINDOW_HEIGHT_KEY, "450"));
        return new Rectangle(x, y, width, height);
    }
}

