/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.tilecache;

import com.bc.ceres.jai.tilecache.MemoryTile;
import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

final class SwappedTile {
    private final File file;
    private final long fileSize;
    private final SampleModel sampleModel;
    private final boolean writable;
    private final Point location;
    private final Object tileCacheMetric;

    SwappedTile(MemoryTile mt, File cacheDir) {
        this.file = new File(cacheDir, mt.getKeyAsString());
        this.fileSize = mt.getTileSize();
        this.sampleModel = mt.getTile().getSampleModel();
        this.location = (Point)mt.getTile().getBounds().getLocation().clone();
        this.writable = mt.getTile() instanceof WritableRaster;
        this.tileCacheMetric = mt.getTileCacheMetric();
    }

    public boolean isAvailable() {
        return this.file.length() == this.fileSize;
    }

    public File getFile() {
        return this.file;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public Point getLocation() {
        return this.location;
    }

    public Object getTileCacheMetric() {
        return this.tileCacheMetric;
    }

    public boolean delete() {
        return this.file.delete();
    }

    public Raster restoreTile() throws IOException {
        DataBuffer dataBuffer;
        try (FileImageInputStream stream = new FileImageInputStream(this.file);){
            dataBuffer = SwappedTile.readTileData(stream, this.sampleModel);
        }
        Raster tile = this.writable ? Raster.createWritableRaster(this.sampleModel, dataBuffer, this.location) : Raster.createRaster(this.sampleModel, dataBuffer, this.location);
        return tile;
    }

    public void storeTile(Raster tile) throws IOException {
        try (FileImageOutputStream stream = new FileImageOutputStream(this.file);){
            SwappedTile.writeTileData(stream, tile.getDataBuffer());
        }
    }

    private static DataBuffer readTileData(ImageInputStream stream, SampleModel sampleModel) throws IOException {
        int dataType = sampleModel.getDataType();
        int arrayLength = stream.readInt();
        int bufferSize = stream.readInt();
        int bufferOffset = stream.readInt();
        if (dataType == 0) {
            byte[] data = new byte[arrayLength];
            stream.readFully(data, 0, arrayLength);
            return new DataBufferByte(data, bufferSize, bufferOffset);
        }
        if (dataType == 2 || dataType == 1) {
            short[] data = new short[arrayLength];
            stream.readFully(data, 0, arrayLength);
            return new DataBufferShort(data, bufferSize, bufferOffset);
        }
        if (dataType == 3) {
            int[] data = new int[arrayLength];
            stream.readFully(data, 0, arrayLength);
            return new DataBufferInt(data, bufferSize, bufferOffset);
        }
        if (dataType == 4) {
            float[] data = new float[arrayLength];
            stream.readFully(data, 0, arrayLength);
            return new DataBufferFloat(data, bufferSize, bufferOffset);
        }
        if (dataType == 5) {
            double[] data = new double[arrayLength];
            stream.readFully(data, 0, arrayLength);
            return new DataBufferDouble(data, bufferSize, bufferOffset);
        }
        throw new IllegalStateException();
    }

    private static void writeTileData(ImageOutputStream stream, DataBuffer dataBuffer) throws IOException {
        Object[] array;
        Object data;
        try {
            Method method = dataBuffer.getClass().getMethod("getData", new Class[0]);
            data = method.invoke((Object)dataBuffer, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("illegal dataBuffer: " + dataBuffer.getClass(), e);
        }
        if (data instanceof byte[]) {
            array = (byte[])data;
            stream.writeInt(array.length);
            stream.writeInt(dataBuffer.getSize());
            stream.writeInt(dataBuffer.getOffset());
            stream.write((byte[])array, dataBuffer.getOffset(), dataBuffer.getSize());
        } else if (data instanceof short[]) {
            array = (short[])data;
            stream.writeInt(array.length);
            stream.writeInt(dataBuffer.getSize());
            stream.writeInt(dataBuffer.getOffset());
            stream.writeShorts((short[])array, dataBuffer.getOffset(), dataBuffer.getSize());
        } else if (data instanceof int[]) {
            array = (int[])data;
            stream.writeInt(array.length);
            stream.writeInt(dataBuffer.getSize());
            stream.writeInt(dataBuffer.getOffset());
            stream.writeInts((int[])array, dataBuffer.getOffset(), dataBuffer.getSize());
        } else if (data instanceof float[]) {
            array = (float[])data;
            stream.writeInt(array.length);
            stream.writeInt(dataBuffer.getSize());
            stream.writeInt(dataBuffer.getOffset());
            stream.writeFloats((float[])array, dataBuffer.getOffset(), dataBuffer.getSize());
        } else if (data instanceof double[]) {
            array = (double[])data;
            stream.writeInt(array.length);
            stream.writeInt(dataBuffer.getSize());
            stream.writeInt(dataBuffer.getOffset());
            stream.writeDoubles((double[])array, dataBuffer.getOffset(), dataBuffer.getSize());
        } else {
            throw new IllegalArgumentException("illegal dataBuffer: " + dataBuffer.getClass());
        }
    }
}

