/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.visat;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.GenericPlacemarkDescriptor;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.pixex.PixExOpUtils;
import org.esa.snap.pixex.visat.CoordinateTableModel;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.SnapFileChooser;
import org.opengis.feature.simple.SimpleFeature;

class AddCsvFileAction
extends AbstractAction {
    private static final String LAST_OPEN_CSV_DIR = "beam.pixex.lastOpenCsvDir";
    private static final String ISO8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private static final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss");
    private final AppContext appContext;
    private final JPanel parent;
    private final CoordinateTableModel tableModel;

    AddCsvFileAction(AppContext appContext, CoordinateTableModel tableModel, JPanel parent) {
        super("Add measurements from CSV file...");
        this.appContext = appContext;
        this.parent = parent;
        this.tableModel = tableModel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PropertyMap preferences = this.appContext.getPreferences();
        SnapFileChooser fileChooser = this.getFileChooser(preferences.getPropertyString(LAST_OPEN_CSV_DIR, SystemUtils.getUserHomeDir().getPath()));
        int answer = fileChooser.showDialog((Component)this.parent, "Select");
        if (answer == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            preferences.setPropertyString(LAST_OPEN_CSV_DIR, selectedFile.getParent());
            try {
                List extendedFeatures = PixExOpUtils.extractFeatures((File)selectedFile);
                for (SimpleFeature extendedFeature : extendedFeatures) {
                    GenericPlacemarkDescriptor placemarkDescriptor = new GenericPlacemarkDescriptor(extendedFeature.getFeatureType());
                    Placemark placemark = placemarkDescriptor.createPlacemark(extendedFeature);
                    this.setName(extendedFeature, placemark);
                    this.setDateTime(extendedFeature, placemark);
                    this.setPlacemarkGeoPos(extendedFeature, placemark);
                    this.tableModel.addPlacemark(placemark);
                }
            }
            catch (IOException exception) {
                this.appContext.handleError(String.format("Error occurred while reading file: %s \n" + exception.getLocalizedMessage() + "\nPossible reason: Other char separator than tabulator used", selectedFile), (Throwable)exception);
            }
        }
    }

    private void setName(SimpleFeature extendedFeature, Placemark placemark) {
        if (extendedFeature.getAttribute("Name") != null) {
            placemark.setName(extendedFeature.getAttribute("Name").toString());
        }
    }

    private void setDateTime(SimpleFeature extendedFeature, Placemark placemark) {
        Object dateTime = extendedFeature.getAttribute("DateTime");
        if (dateTime != null && dateTime instanceof String) {
            try {
                Date date = dateFormat.parse((String)dateTime);
                placemark.getFeature().setAttribute("dateTime", (Object)date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void setPlacemarkGeoPos(SimpleFeature extendedFeature, Placemark placemark) throws IOException {
        GeoPos geoPos = PixExOpUtils.getGeoPos((SimpleFeature)extendedFeature);
        placemark.setGeoPos(geoPos);
    }

    private SnapFileChooser getFileChooser(String lastDir) {
        SnapFileChooser fileChooser = new SnapFileChooser();
        fileChooser.setFileFilter((FileFilter)new SnapFileFilter("CSV", new String[]{".csv", ".txt", ".ascii"}, "CSV files"));
        fileChooser.setCurrentDirectory(new File(lastDir));
        return fileChooser;
    }
}

