/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor.template;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.template.TemplateContext;
import org.esa.snap.core.gpf.descriptor.template.TemplateException;
import org.esa.snap.core.gpf.descriptor.template.TemplateFile;
import org.esa.snap.core.gpf.descriptor.template.TemplateType;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;

public abstract class TemplateEngine<C> {
    private static final String LINE_SEPARATOR = "\r\n|\n";
    protected ToolAdapterOperatorDescriptor operatorDescriptor;
    protected TemplateContext<C> context;
    protected TemplateContext<C> lastContext;

    protected TemplateEngine(ToolAdapterOperatorDescriptor descriptor) {
        this.operatorDescriptor = descriptor;
    }

    public abstract void parse(TemplateFile var1) throws TemplateException;

    public abstract String execute(TemplateFile var1, Map<String, Object> var2) throws TemplateException;

    public abstract TemplateType getType();

    public TemplateContext<C> getContext() {
        return this.context != null ? this.context : this.lastContext;
    }

    public static TemplateEngine createInstance(ToolAdapterOperatorDescriptor descriptor, TemplateType templateType) {
        return TemplateEngine.createInstance(descriptor, templateType, false);
    }

    public static TemplateEngine createInstance(ToolAdapterOperatorDescriptor descriptor, TemplateType templateType, boolean stateful) {
        if (templateType == null) {
            throw new IllegalArgumentException("null template");
        }
        switch (templateType) {
            case JAVASCRIPT: {
                return new JavascriptEngine(descriptor, stateful);
            }
        }
        return new VelocityEngine(descriptor, stateful);
    }

    public List<String> getLines(TemplateFile template, Map<String, Object> parameters) throws TemplateException {
        if (template == null) {
            throw new IllegalArgumentException("null template");
        }
        String result = this.execute(template, parameters);
        return Arrays.asList(result.split(LINE_SEPARATOR));
    }

    public Path getTemplateBasePath() {
        Path adapterPath = null;
        if (this.operatorDescriptor != null) {
            adapterPath = ToolAdapterIO.getAdaptersPath().resolve(this.operatorDescriptor.getAlias());
        }
        return adapterPath;
    }

    static class JavascriptEngine
    extends TemplateEngine<ScriptContext> {
        private ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("nashorn");

        JavascriptEngine(ToolAdapterOperatorDescriptor descriptor, boolean stateful) {
            super(descriptor);
        }

        @Override
        public void parse(TemplateFile template) throws TemplateException {
            try {
                if (template == null) {
                    throw new ScriptException("null template");
                }
                String contents = template.getContents();
                this.scriptEngine.eval(contents);
            }
            catch (IOException | ScriptException ex) {
                throw new TemplateException(ex);
            }
        }

        @Override
        public String execute(TemplateFile template, Map<String, Object> parameters) throws TemplateException {
            String result;
            SimpleBindings bindings = new SimpleBindings(parameters);
            this.scriptEngine.setBindings(bindings, 100);
            StringWriter writer = new StringWriter();
            ScriptContext context = this.scriptEngine.getContext();
            context.setWriter(writer);
            try {
                String contents = template.getContents();
                this.scriptEngine.eval(contents);
                this.lastContext = new JavaScriptCtx(this.scriptEngine.getContext());
                result = writer.toString();
            }
            catch (IOException | ScriptException e) {
                throw new TemplateException(e);
            }
            return result;
        }

        @Override
        public TemplateType getType() {
            return TemplateType.JAVASCRIPT;
        }

        static class JavaScriptCtx
        extends TemplateContext<ScriptContext> {
            public JavaScriptCtx(ScriptContext wrappedContext) {
                super(wrappedContext);
            }

            @Override
            public Object getValue(String name) {
                return this.context != null ? ((ScriptContext)this.context).getAttribute(name) : null;
            }
        }
    }

    static class VelocityEngine
    extends TemplateEngine<VelocityContext> {
        private String macroTemplateContents;

        VelocityEngine(ToolAdapterOperatorDescriptor descriptor, boolean stateful) {
            super(descriptor);
            if (stateful) {
                this.context = new VelocityCtx(new VelocityContext());
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("macros.vm")));){
                String line;
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line).append("\n");
                }
                if (builder.length() > 0) {
                    builder.setLength(builder.length() - 1);
                    this.macroTemplateContents = builder.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void parse(TemplateFile template) throws TemplateException {
            boolean evalResult;
            org.apache.velocity.app.VelocityEngine veloEngine = new org.apache.velocity.app.VelocityEngine();
            File templateFile = template.getTemplatePath();
            veloEngine.setProperty("file.resource.loader.path", (Object)templateFile.getParent());
            List<SystemVariable> variables = this.operatorDescriptor.getVariables();
            for (SystemVariable variable : variables) {
                veloEngine.addProperty(variable.getKey(), (Object)variable.getValue());
            }
            veloEngine.init();
            try {
                String contents = template.getContents();
                evalResult = veloEngine.evaluate((Context)new VelocityContext(), (Writer)new StringWriter(), templateFile.getName(), contents);
            }
            catch (Exception inner) {
                throw new TemplateException(inner);
            }
            if (!evalResult) {
                throw new TemplateException("Template evaluation failed");
            }
        }

        @Override
        public String execute(TemplateFile template, Map<String, Object> parameters) throws TemplateException {
            try {
                org.apache.velocity.app.VelocityEngine veloEngine = new org.apache.velocity.app.VelocityEngine();
                VelocityContext veloContext = this.context != null ? (VelocityContext)this.context.getContext() : new VelocityContext();
                File templateFile = template.getTemplatePath();
                veloEngine.setProperty("file.resource.loader.path", (Object)templateFile.getParent());
                List<SystemVariable> variables = this.operatorDescriptor.getVariables();
                for (SystemVariable systemVariable : variables) {
                    veloEngine.addProperty(systemVariable.getKey(), (Object)systemVariable.getValue());
                    veloContext.put(systemVariable.getKey(), (Object)systemVariable.getValue());
                }
                veloEngine.init();
                Template veloTemplate = this.createTemplate(veloEngine, templateFile);
                for (String key : parameters.keySet()) {
                    veloContext.put(key, parameters.get(key));
                }
                StringWriter stringWriter = new StringWriter();
                veloTemplate.merge((Context)veloContext, (Writer)stringWriter);
                this.lastContext = new VelocityCtx(veloContext);
                return stringWriter.toString();
            }
            catch (Exception inner) {
                throw new TemplateException(inner);
            }
        }

        @Override
        public TemplateType getType() {
            return TemplateType.VELOCITY;
        }

        private Template createTemplate(org.apache.velocity.app.VelocityEngine engine, File templateFile) throws ParseException, IOException {
            Template template;
            if (this.macroTemplateContents != null && !this.macroTemplateContents.isEmpty()) {
                RuntimeServices runtimeServices = RuntimeSingleton.getRuntimeServices();
                String veloTemplate = this.macroTemplateContents + "\n" + new String(Files.readAllBytes(templateFile.toPath()));
                StringReader reader = new StringReader(veloTemplate);
                SimpleNode node = runtimeServices.parse((Reader)reader, templateFile.getName());
                template = new Template();
                template.setRuntimeServices(runtimeServices);
                template.setData((Object)node);
                template.initDocument();
            } else {
                template = engine.getTemplate(templateFile.getName());
            }
            return template;
        }

        static class VelocityCtx
        extends TemplateContext<VelocityContext> {
            public VelocityCtx(VelocityContext wrappedContext) {
                super(wrappedContext);
            }

            @Override
            public Object getValue(String name) {
                return this.context != null ? ((VelocityContext)this.context).get(name) : null;
            }
        }
    }
}

