/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;

@XStreamAlias(value="osvariable")
public class SystemDependentVariable
extends SystemVariable {
    @XStreamOmitField
    private volatile Map<OS, String> values;
    @XStreamOmitField
    private OS currentOS;
    String windows;
    String linux;
    String macosx;
    private boolean isTransient;

    public SystemDependentVariable() {
        this.initialize();
    }

    public SystemDependentVariable(String key, String value) {
        super(key, value);
        this.initialize();
        this.setValue(value);
        this.isTransient = false;
    }

    @Override
    public String getValue() {
        String retVal;
        if (this.values == null) {
            this.initialize();
        }
        return (retVal = this.resolve()) != null && !retVal.isEmpty() ? retVal : (String)this.values.getOrDefault((Object)this.currentOS, null);
    }

    @Override
    public void setValue(String value) {
        this.values.put(this.currentOS, value);
        this.value = value;
        if (!this.isTransient && value != null && !value.isEmpty() && this.isShared) {
            ToolAdapterIO.saveVariable(this.key, value);
        }
    }

    @Override
    public SystemVariable createCopy() {
        SystemDependentVariable copy = new SystemDependentVariable();
        copy.setKey(this.getKey());
        copy.setShared(this.isShared());
        copy.setValue(this.getValue());
        copy.setWindows(this.getWindows());
        copy.setLinux(this.getLinux());
        copy.setMacosx(this.getMacosx());
        return copy;
    }

    public String getWindows() {
        return this.windows == null ? this.values.get((Object)OS.windows) : this.windows;
    }

    public void setWindows(String value) {
        this.windows = value;
        if (this.currentOS == OS.windows) {
            this.setValue(value);
        }
    }

    public String getLinux() {
        return this.linux == null ? this.values.get((Object)OS.linux) : this.linux;
    }

    public void setLinux(String value) {
        this.linux = value;
        if (this.currentOS == OS.linux) {
            this.setValue(value);
        }
    }

    public String getMacosx() {
        return this.macosx == null ? this.values.get((Object)OS.macosx) : this.macosx;
    }

    public void setMacosx(String value) {
        this.macosx = value;
        if (this.currentOS == OS.macosx) {
            this.setValue(value);
        }
    }

    public void setTransient(boolean value) {
        this.isTransient = value;
    }

    private void initialize() {
        this.values = new HashMap<OS, String>();
        try {
            this.currentOS = Enum.valueOf(OS.class, ToolAdapterIO.getOsFamily());
        }
        catch (IllegalArgumentException ignored) {
            this.currentOS = OS.unsupported;
        }
        this.values.keySet().stream().filter(key -> key != this.currentOS).forEach(key -> {
            switch (key) {
                case windows: {
                    this.values.put((OS)((Object)key), this.windows == null ? "" : this.windows);
                    break;
                }
                case linux: {
                    this.values.put((OS)((Object)key), this.linux == null ? "" : this.linux);
                    break;
                }
                case macosx: {
                    this.values.put((OS)((Object)key), this.macosx == null ? "" : this.macosx);
                    break;
                }
                case unsupported: {
                    this.values.put((OS)((Object)key), "");
                }
            }
        });
        this.values.put(this.currentOS, this.resolve());
    }

    public String getCurrentOSValue() {
        return this.values.get((Object)this.currentOS);
    }

    static enum OS {
        windows,
        linux,
        macosx,
        unsupported;

    }
}

