/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.grender.support;

import com.bc.ceres.core.Assert;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.support.DefaultViewport;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class BufferedImageRendering
implements Rendering {
    private BufferedImage image;
    private Graphics2D graphics;
    private Viewport viewport;

    public BufferedImageRendering(int width, int height) {
        this(new BufferedImage(width, height, 6), new DefaultViewport(new Rectangle(0, 0, width, height), true));
    }

    public BufferedImageRendering(BufferedImage image) {
        this(image, new DefaultViewport(new Rectangle(0, 0, image.getWidth(), image.getHeight()), true));
    }

    public BufferedImageRendering(BufferedImage image, Viewport viewport) {
        Assert.notNull((Object)image, (String)"image");
        Assert.notNull((Object)viewport, (String)"viewport");
        this.image = image;
        this.viewport = viewport;
        this.updateViewportViewBounds();
    }

    @Override
    public synchronized Graphics2D getGraphics() {
        if (this.graphics == null) {
            this.graphics = this.image.createGraphics();
        }
        return this.graphics;
    }

    @Override
    public synchronized Viewport getViewport() {
        return this.viewport;
    }

    public synchronized void setViewport(Viewport viewport) {
        Assert.notNull((Object)viewport, (String)"viewport");
        this.viewport = viewport;
        this.updateViewportViewBounds();
    }

    public synchronized BufferedImage getImage() {
        return this.image;
    }

    public synchronized void setImage(BufferedImage image) {
        Assert.notNull((Object)image, (String)"image");
        this.disposeGraphics();
        this.image = image;
        this.updateViewportViewBounds();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.disposeGraphics();
    }

    private void disposeGraphics() {
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
    }

    private void updateViewportViewBounds() {
        this.viewport.setViewBounds(new Rectangle(this.image.getMinX(), this.image.getMinY(), this.image.getWidth(), this.image.getHeight()));
    }
}

