/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection.support;

import com.bc.ceres.swing.selection.AbstractSelectionContext;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.support.DefaultSelection;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListSelectionContext
extends AbstractSelectionContext {
    private final ListSelectionListener listSelectionListener = new ListSelectionHandler();
    private JList list;

    public ListSelectionContext(JList list) {
        this.list = list;
        this.list.addListSelectionListener(this.listSelectionListener);
    }

    @Override
    public Selection getSelection() {
        if (this.list.getSelectedIndex() == -1) {
            return DefaultSelection.EMPTY;
        }
        return new DefaultSelection<Object>(this.list.getSelectedValues());
    }

    @Override
    public void setSelection(Selection selection) {
        if (selection.isEmpty()) {
            this.list.clearSelection();
            return;
        }
        ListModel listModel = this.list.getModel();
        Object[] selectedElements = selection.getSelectedValues();
        int[] indices = new int[selectedElements.length];
        int indexCount = 0;
        block0: for (int i = 0; i < listModel.getSize(); ++i) {
            Object element = listModel.getElementAt(i);
            for (Object selectedElement : selectedElements) {
                if (!element.equals(selectedElement)) continue;
                indices[indexCount++] = i;
                continue block0;
            }
        }
        if (indexCount == 0) {
            this.list.clearSelection();
            return;
        }
        if (indexCount < indices.length) {
            int[] t = new int[indexCount];
            System.arraycopy(indices, 0, t, 0, indexCount);
            indices = t;
        }
        this.list.setValueIsAdjusting(true);
        this.list.setSelectedIndices(indices);
        this.list.setValueIsAdjusting(false);
    }

    @Override
    public void insert(Transferable transferable) throws IOException, UnsupportedFlavorException {
        Object transferData = transferable.getTransferData(DataFlavor.stringFlavor);
        if (transferData != null) {
            int selectedIndex = this.list.getSelectedIndex();
            if (selectedIndex >= 0) {
                ((DefaultListModel)this.list.getModel()).add(selectedIndex, transferData.toString());
            } else {
                ((DefaultListModel)this.list.getModel()).addElement(transferData.toString());
            }
        }
    }

    @Override
    public boolean canInsert(Transferable contents) {
        return this.isListEditable() && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    @Override
    public boolean canDeleteSelection() {
        return !this.getSelection().isEmpty() && this.isListEditable();
    }

    @Override
    public void deleteSelection() {
        Object[] items;
        for (Object item : items = this.getList().getSelectedValues()) {
            ((DefaultListModel)this.getList().getModel()).removeElement(item);
        }
    }

    boolean isListEditable() {
        return this.getList().getModel() instanceof DefaultListModel;
    }

    public JList getList() {
        return this.list;
    }

    public void setList(JList list) {
        if (list != this.list) {
            this.list.removeListSelectionListener(this.listSelectionListener);
            this.list = list;
            this.list.addListSelectionListener(this.listSelectionListener);
            this.fireSelectionChange(this.getSelection());
        }
    }

    protected void handleListSelectionChange(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.fireSelectionChange(this.getSelection());
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        private ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            ListSelectionContext.this.handleListSelectionChange(event);
        }
    }
}

