/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.gpf;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.image.RasterDataNodeSampleOpImage;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.landcover.dataio.FileLandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.LandCoverFactory;
import org.esa.snap.landcover.dataio.LandCoverModel;
import org.esa.snap.landcover.dataio.LandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.LandCoverModelRegistry;

@OperatorMetadata(alias="AddLandCover", category="Raster/Masks", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Creates a land cover band")
public final class AddLandCoverOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The land cover model.", defaultValue="AAFC Canada Sand Pct", label="Land Cover Model")
    private String[] landCoverNames = new String[]{"AAFC Canada Sand Pct"};
    @Parameter(description="The external file.", defaultValue="", label="External File")
    private File externalFile = null;
    @Parameter(defaultValue="NEAREST_NEIGHBOUR", label="Resampling Method")
    private String resamplingMethod = "NEAREST_NEIGHBOUR";
    public static final String DEFAULT_BAND_NAME = "land_cover";

    public void initialize() throws OperatorException {
        try {
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    void createTargetProduct() throws Exception {
        this.ensureSingleRasterSize(new Product[]{this.sourceProduct});
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        for (Band band : this.sourceProduct.getBands()) {
            ProductUtils.copyBand((String)band.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        }
        for (String string : this.landCoverNames) {
            LandCoverParameters param = new LandCoverParameters(string, this.resamplingMethod);
            AddLandCoverOp.AddLandCover(this.targetProduct, param);
        }
        if (this.externalFile != null && this.externalFile.exists()) {
            LandCoverParameters landCoverParameters = new LandCoverParameters(this.externalFile.getName(), this.externalFile, this.resamplingMethod);
            AddLandCoverOp.AddLandCover(this.targetProduct, landCoverParameters);
        }
    }

    public static void AddLandCover(Product product, LandCoverParameters param) throws Exception {
        String name = LandCoverFactory.getProperName(param.name);
        LandCoverModelDescriptor descriptor = null;
        if (param.externalFile != null) {
            descriptor = new FileLandCoverModelDescriptor(param.externalFile);
        } else {
            LandCoverModelRegistry modelRegistry = LandCoverModelRegistry.getInstance();
            descriptor = modelRegistry.getDescriptor(name);
        }
        if (descriptor == null) {
            throw new OperatorException("The Land Cover '" + name + "' is not supported.");
        }
        if (!descriptor.isInstalled()) {
            descriptor.installFiles();
        }
        File[] files = descriptor.getInstallDir().listFiles();
        if (!(descriptor.isInstalled() || files != null && files.length != 0)) {
            throw new Exception(descriptor.getName() + " needs to be installed in " + descriptor.getInstallDir().toString());
        }
        if (descriptor.getDataType() < 30) {
            param.resamplingMethod = "NEAREST_NEIGHBOUR";
        }
        Resampling resampling = Resampling.NEAREST_NEIGHBOUR;
        if (param.resamplingMethod != null && (resampling = ResamplingFactory.createResampling((String)param.resamplingMethod)) == null) {
            throw new OperatorException("Resampling method " + param.resamplingMethod + " is invalid");
        }
        LandCoverModel landcover = descriptor.createLandCoverModel(resampling);
        AddLandCoverOp.addLandCoverBand(product, landcover, param.bandName);
    }

    private static void addLandCoverBand(Product product, LandCoverModel landcover, String bandName) {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        LandCoverModelDescriptor descriptor = landcover.getDescriptor();
        Band band = product.addBand(AddLandCoverOp.getValidBandName(bandName, product), descriptor.getDataType());
        band.setNoDataValueUsed(true);
        band.setNoDataValue(descriptor.getNoDataValue());
        band.setUnit(descriptor.getUnit());
        band.setDescription(descriptor.getName());
        IndexCoding indexCoding = descriptor.getIndexCoding();
        if (indexCoding != null) {
            product.getIndexCodingGroup().add((ProductNode)indexCoding);
            band.setSampleCoding((SampleCoding)indexCoding);
            band.setImageInfo(descriptor.getImageInfo());
        }
        band.setSourceImage(AddLandCoverOp.createLandCoverSourceImage(landcover, geoCoding, band));
    }

    private static RenderedImage createLandCoverSourceImage(final LandCoverModel landcover, final GeoCoding geoCoding, final Band band) {
        return new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource(band.createMultiLevelModel()){

            protected RenderedImage createImage(int level) {
                return new LandCoverSourceImage(landcover, geoCoding, band, ResolutionLevel.create((MultiLevelModel)this.getModel(), (int)level));
            }
        });
    }

    public static String getValidBandName(String bandName, Product product) {
        String newBandName = bandName;
        if (!bandName.startsWith(DEFAULT_BAND_NAME)) {
            newBandName = "land_cover_" + bandName;
        }
        int i = 2;
        while (product.containsBand(newBandName)) {
            newBandName = String.format("%s_%d", newBandName, i);
            ++i;
        }
        return newBandName;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AddLandCoverOp.class);
        }
    }

    public static class LandCoverParameters {
        public String name;
        public String resamplingMethod;
        public String bandName = "land_cover";
        public File externalFile = null;

        public LandCoverParameters(String name, String resamplingMethod) {
            this.name = name;
            this.resamplingMethod = resamplingMethod;
            this.bandName = name;
        }

        public LandCoverParameters(String name, File externalFile, String resamplingMethod) {
            this(name, resamplingMethod);
            this.name = externalFile.getName();
            this.externalFile = externalFile;
        }
    }

    private static class LandCoverSourceImage
    extends RasterDataNodeSampleOpImage {
        private final LandCoverModel landcover;
        private final GeoCoding geoCoding;
        private double noDataValue;

        public LandCoverSourceImage(LandCoverModel landcover, GeoCoding geoCoding, Band band, ResolutionLevel level) {
            super((RasterDataNode)band, level);
            this.landcover = landcover;
            this.geoCoding = geoCoding;
            this.noDataValue = landcover.getDescriptor().getNoDataValue();
        }

        protected double computeSample(int sourceX, int sourceY) {
            try {
                return this.landcover.getLandCover(this.geoCoding.getGeoPos(new PixelPos((double)((float)sourceX + 0.5f), (double)((float)sourceY + 0.5f)), null));
            }
            catch (Exception e) {
                return this.noDataValue;
            }
        }
    }
}

