/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.percentile.interpolated;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.WildcardMatcher;
import org.esa.snap.statistics.percentile.interpolated.ProductValidator;

public class ProductLoader {
    private final String[] sourceProductPaths;
    private final ProductValidator productValidator;
    private final Logger logger;

    public ProductLoader(String[] sourceProductPaths, ProductValidator productValidator, Logger logger) {
        this.sourceProductPaths = sourceProductPaths;
        this.productValidator = productValidator;
        this.logger = logger;
    }

    public Product[] loadProducts() {
        ArrayList<Product> products = new ArrayList<Product>();
        for (String sourceProductPath : this.sourceProductPaths) {
            File[] files;
            try {
                files = WildcardMatcher.glob((String)sourceProductPath);
            }
            catch (IOException e) {
                this.logger.severe("'" + sourceProductPath + "' is not a valid products wildcard path.");
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            for (File productFile : files) {
                Product product;
                try {
                    this.logger.info("Trying to open product file '" + productFile.getAbsolutePath() + "'.");
                    product = this.loadProduct(productFile);
                }
                catch (IOException e) {
                    this.logger.severe("Unable to read product '" + productFile.getAbsolutePath() + "'.");
                    this.logger.log(Level.SEVERE, e.getMessage(), e);
                    continue;
                }
                if (this.productValidator.isValid(product)) {
                    products.add(product);
                    continue;
                }
                if (product == null) continue;
                product.dispose();
            }
        }
        return products.toArray(new Product[products.size()]);
    }

    private Product loadProduct(File path) throws IOException {
        try {
            return ProductIO.readProduct((File)path);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

