/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.binding.dom.DefaultDomConverter;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.jai.tilecache.DefaultSwapSpace;
import com.bc.ceres.jai.tilecache.SwapSpace;
import com.bc.ceres.jai.tilecache.SwappingTileCache;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileCache;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorCancelException;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.annotations.TargetProperty;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.descriptor.AnnotationOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.PropertySetDescriptorFactory;
import org.esa.snap.core.gpf.graph.GraphOp;
import org.esa.snap.core.gpf.internal.OperatorConfiguration;
import org.esa.snap.core.gpf.internal.OperatorImage;
import org.esa.snap.core.gpf.internal.OperatorImageTileStack;
import org.esa.snap.core.gpf.internal.OperatorProductReader;
import org.esa.snap.core.gpf.internal.RasterDataNodeValues;
import org.esa.snap.core.gpf.internal.TileImpl;
import org.esa.snap.core.gpf.monitor.TileComputationEvent;
import org.esa.snap.core.gpf.monitor.TileComputationObserver;
import org.esa.snap.core.util.ModuleMetadata;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.jai.JAIUtils;
import org.esa.snap.runtime.Config;

public class OperatorContext {
    static final String PROCESSING_GRAPH_ELEMENT_NAME = "Processing_Graph";
    private static final String DATETIME_OUTPUT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final SimpleDateFormat DATETIME_OUTPUT_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static TileCache tileCache;
    private static TileComputationObserver tileComputationObserver;
    private final Operator operator;
    private final List<Product> sourceProductList;
    private final Map<String, Product> sourceProductMap;
    private final Map<String, Object> targetPropertyMap;
    private final RenderingHints renderingHints;
    private final boolean computeTileMethodImplemented;
    private final boolean computeTileStackMethodImplemented;
    private String id;
    private Product targetProduct;
    private OperatorSpi operatorSpi;
    private Map<Band, OperatorImage> targetImageMap;
    private OperatorConfiguration configuration;
    private Logger logger;
    private boolean cancelled;
    private boolean disposed;
    private PropertySet parameterSet;
    private boolean initialising;
    private boolean requiresAllBands;
    private boolean executed;
    private final ThreadLocal<SuspendableStopWatch> nettoWatch = new ThreadLocal<SuspendableStopWatch>(){

        @Override
        protected SuspendableStopWatch initialValue() {
            return new SuspendableStopWatch();
        }
    };

    public OperatorContext(Operator operator) {
        if (operator == null) {
            throw new NullPointerException("operator");
        }
        this.operator = operator;
        this.computeTileMethodImplemented = OperatorContext.isComputeTileMethodImplemented(operator.getClass());
        this.computeTileStackMethodImplemented = OperatorContext.isComputeTileStackMethodImplemented(operator.getClass());
        this.sourceProductList = new ArrayList<Product>(3);
        this.sourceProductMap = new HashMap<String, Product>(3);
        this.targetPropertyMap = new HashMap<String, Object>(3);
        this.logger = SystemUtils.LOG;
        this.renderingHints = new RenderingHints(JAI.KEY_TILE_CACHE_METRIC, this);
        this.startTileComputationObservation();
    }

    public static void setTileCache(OpImage image) {
        boolean disableTileCache = Config.instance().preferences().getBoolean("snap.gpf.disableTileCache", false);
        if (disableTileCache) {
            image.setTileCache(null);
        } else if (image.getTileCache() == null) {
            image.setTileCache(OperatorContext.getTileCache());
            SystemUtils.LOG.finest(String.format("Tile cache assigned to %s", image));
        }
    }

    private static synchronized TileCache getTileCache() {
        if (tileCache == null) {
            boolean useFileTileCache = Config.instance().preferences().getBoolean("snap.gpf.useFileTileCache", false);
            tileCache = useFileTileCache ? new SwappingTileCache(JAI.getDefaultInstance().getTileCache().getMemoryCapacity(), (SwapSpace)new DefaultSwapSpace(SwappingTileCache.DEFAULT_SWAP_DIR, SystemUtils.LOG)) : JAI.getDefaultInstance().getTileCache();
            SystemUtils.LOG.fine(String.format("All GPF operators will share an instance of %s with a capacity of %dM", tileCache.getClass().getName(), tileCache.getMemoryCapacity() / 0x100000L));
        }
        return tileCache;
    }

    public String getId() {
        if (this.id == null) {
            OperatorDescriptor descriptor = this.getOperatorSpi().getOperatorDescriptor();
            String aliasName = descriptor.getAlias() != null ? descriptor.getAlias() : descriptor.getName();
            this.id = aliasName + '$' + Long.toHexString(System.currentTimeMillis()).toUpperCase();
        }
        return this.id;
    }

    public void setId(String id) {
        Assert.notNull((Object)id, (String)"id");
        this.id = id;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        Assert.notNull((Object)logger, (String)"logger");
        this.logger = logger;
    }

    public Product getSourceProduct(String id) {
        return this.sourceProductMap.get(id);
    }

    public void setSourceProduct(String id, Product product) {
        if (product != null) {
            if (!this.sourceProductList.contains(product)) {
                this.sourceProductList.add(product);
            }
            this.sourceProductMap.put(id, product);
            this.updatePropertyDescriptors();
        }
    }

    public Product[] getSourceProducts() {
        return this.sourceProductList.toArray(new Product[this.sourceProductList.size()]);
    }

    public void setSourceProducts(Product[] products) {
        this.sourceProductList.clear();
        this.sourceProductMap.clear();
        for (int i = 0; i < products.length; ++i) {
            Product product = products[i];
            int productIndex = i + 1;
            this.setSourceProduct("sourceProduct." + productIndex, product);
            this.setSourceProduct("sourceProduct" + productIndex, product);
        }
    }

    public void setSourceProducts(Map<String, Product> sourceProducts) {
        this.sourceProductList.clear();
        this.sourceProductMap.clear();
        Set<Map.Entry<String, Product>> entries = sourceProducts.entrySet();
        for (Map.Entry<String, Product> entry : entries) {
            this.setSourceProduct(entry.getKey(), entry.getValue());
        }
    }

    public String getSourceProductId(Product product) {
        Set<Map.Entry<String, Product>> entrySet = this.sourceProductMap.entrySet();
        ArrayList<String> mappedIds = new ArrayList<String>();
        for (Map.Entry<String, Product> entry : entrySet) {
            if (entry.getValue() != product) continue;
            mappedIds.add(entry.getKey());
        }
        if (mappedIds.isEmpty()) {
            return null;
        }
        String id = (String)mappedIds.get(0);
        for (String mappedId : mappedIds) {
            if (!mappedId.contains(".")) continue;
            id = mappedId;
        }
        return id;
    }

    public Product getTargetProduct() throws OperatorException {
        if (this.targetProduct == null) {
            this.initializeOperator();
        }
        return this.targetProduct;
    }

    public void setTargetProduct(Product targetProduct) {
        Assert.notNull((Object)targetProduct, (String)"targetProduct");
        this.targetProduct = targetProduct;
    }

    public Object getTargetProperty(String name) {
        this.getTargetProduct();
        return this.targetPropertyMap.get(name);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void checkForCancellation() throws OperatorException {
        if (this.isCancelled()) {
            throw new OperatorCancelException("Operation canceled.");
        }
    }

    public OperatorSpi getOperatorSpi() {
        if (this.operatorSpi == null) {
            this.operatorSpi = new OperatorSpi(this.operator.getClass()){};
        }
        return this.operatorSpi;
    }

    public void setOperatorSpi(OperatorSpi operatorSpi) {
        this.operatorSpi = operatorSpi;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object getParameter(String name) {
        Assert.notNull((Object)name, (String)"name");
        return this.getParameterSet().getValue(name);
    }

    public void setParameter(String name, Object value) {
        Assert.notNull((Object)name, (String)"name");
        PropertySet paramSet = this.getParameterSet();
        if (paramSet.isPropertyDefined(name)) {
            Property property = paramSet.getProperty(name);
            if (value != null) {
                this.setPropertyValue(value, property);
            } else {
                paramSet.removeProperty(property);
            }
        }
    }

    private void setPropertyValue(Object value, Property property) {
        try {
            if (value instanceof String && !String.class.isAssignableFrom(property.getType())) {
                property.setValueFromText((String)value);
            } else {
                property.setValue(value);
            }
        }
        catch (ValidationException e) {
            throw new OperatorException(this.formatExceptionMessage("%s", e.getMessage()), e);
        }
    }

    public Map<String, Object> getParameterMap() {
        PropertySet paramSet = this.getParameterSet();
        Property[] properties = paramSet.getProperties();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        for (Property property : properties) {
            parameterMap.put(property.getName(), property.getValue());
        }
        return parameterMap;
    }

    public void setParameterMap(Map<String, Object> parameters) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            this.setParameter(entry.getKey(), entry.getValue());
        }
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void addRenderingHints(RenderingHints renderingHints) {
        this.renderingHints.add(renderingHints);
    }

    public void setConfiguration(OperatorConfiguration opConfiguration) {
        this.configuration = opConfiguration;
    }

    public boolean isInitialized() {
        return this.targetProduct != null;
    }

    public boolean isComputeTileMethodImplemented() {
        return this.computeTileMethodImplemented;
    }

    public boolean isComputeTileStackMethodImplemented() {
        return this.computeTileStackMethodImplemented;
    }

    public Tile getSourceTile(RasterDataNode rasterDataNode, Rectangle region) {
        return this.getSourceTile(rasterDataNode, region, null);
    }

    public Tile getSourceTile(RasterDataNode rasterDataNode, Rectangle region, BorderExtender borderExtender) {
        this.suspendWatch();
        MultiLevelImage image = rasterDataNode.getSourceImage();
        Raster awtRaster = borderExtender != null ? image.getExtendedData(region, borderExtender) : image.getData(region);
        this.resumeWatch();
        return new TileImpl(rasterDataNode, awtRaster);
    }

    public OperatorImage getTargetImage(Band band) {
        return this.targetImageMap.get(band);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.configuration = null;
            this.sourceProductMap.clear();
            this.sourceProductList.clear();
            Collection<OperatorImage> operatorImages = this.targetImageMap.values();
            for (OperatorImage image : operatorImages) {
                image.dispose();
            }
            this.targetImageMap.clear();
            this.operator.dispose();
        }
    }

    private static boolean isComputeTileMethodImplemented(Class<? extends Operator> aClass) {
        return OperatorContext.implementsMethod(aClass, "computeTile", new Class[]{Band.class, Tile.class, ProgressMonitor.class});
    }

    private static boolean isComputeTileStackMethodImplemented(Class<? extends Operator> aClass) {
        return OperatorContext.implementsMethod(aClass, "computeTileStack", new Class[]{Map.class, Rectangle.class, ProgressMonitor.class});
    }

    private boolean operatorMustComputeTileStack() {
        return this.operator.canComputeTileStack() && !this.operator.canComputeTile();
    }

    private static boolean implementsMethod(Class<?> aClass, String methodName, Class[] methodParameterTypes) {
        while (!Operator.class.equals(aClass) && Operator.class.isAssignableFrom(aClass)) {
            try {
                Method declaredMethod = aClass.getDeclaredMethod(methodName, methodParameterTypes);
                return declaredMethod.getModifiers() != 1024;
            }
            catch (NoSuchMethodException e) {
                aClass = aClass.getSuperclass();
                continue;
            }
            break;
        }
        return false;
    }

    private void initializeOperator() throws OperatorException {
        Assert.state((this.targetProduct == null ? 1 : 0) != 0, (String)"targetProduct == null");
        Assert.state((!this.initialising ? 1 : 0) != 0, (String)"!initialising, attempt to call getTargetProduct() from within initialise()?");
        try {
            this.initialising = true;
            if (!(this.operator instanceof GraphOp)) {
                this.initSourceProductFields();
                this.updatePropertyDescriptors();
                this.injectConfiguration();
            }
            this.operator.initialize();
            this.initTargetProduct();
            this.initTargetProperties(this.operator.getClass());
            this.initTargetImages();
            this.initGraphMetadata();
            this.targetProduct.setModified(false);
        }
        finally {
            this.initialising = false;
        }
    }

    public void updateOperator() throws OperatorException {
        this.targetProduct = null;
        this.executed = false;
        this.initializeOperator();
    }

    public PropertySet getParameterSet() {
        if (this.parameterSet == null) {
            if (this.operatorSpi == null) {
                ParameterDescriptorFactory parameterDescriptorFactory = new ParameterDescriptorFactory(this.sourceProductMap);
                this.parameterSet = PropertyContainer.createObjectBacked((Object)this.operator, (PropertyDescriptorFactory)parameterDescriptorFactory);
            } else {
                PropertySetDescriptor propertySetDescriptor;
                OperatorDescriptor operatorDescriptor = this.operatorSpi.getOperatorDescriptor();
                try {
                    propertySetDescriptor = PropertySetDescriptorFactory.createForOperator(operatorDescriptor, this.sourceProductMap);
                }
                catch (ConversionException e) {
                    throw new OperatorException(e);
                }
                this.parameterSet = operatorDescriptor instanceof AnnotationOperatorDescriptor ? PropertyContainer.createObjectBacked((Object)this.operator, (PropertySetDescriptor)propertySetDescriptor) : PropertyContainer.createMapBacked(new HashMap(), (PropertySetDescriptor)propertySetDescriptor);
            }
        }
        return this.parameterSet;
    }

    private void initGraphMetadata() {
        MetadataElement metadataRoot = this.targetProduct.getMetadataRoot();
        MetadataElement targetGraphME = metadataRoot.getElement(PROCESSING_GRAPH_ELEMENT_NAME);
        if (targetGraphME == null) {
            targetGraphME = new MetadataElement(PROCESSING_GRAPH_ELEMENT_NAME);
            metadataRoot.addElement(targetGraphME);
        }
        this.convertOperatorContextToMetadata(this, targetGraphME);
    }

    private void convertOperatorContextToMetadata(OperatorContext context, MetadataElement targetGraphME) throws OperatorException {
        OperatorSpiRegistry operatorSpiRegistry;
        OperatorSpi operatorSpi;
        String opId = context.getId();
        boolean contains = false;
        int nodeElementCount = 0;
        for (MetadataElement element : targetGraphME.getElements()) {
            MetadataAttribute idAttribute = element.getAttribute("id");
            if (idAttribute != null && idAttribute.getData().getElemString().equals(opId)) {
                contains = true;
            }
            if (!element.getName().startsWith("node")) continue;
            ++nodeElementCount;
        }
        if (contains) {
            return;
        }
        Class<?> operatorClass = context.operator.getClass();
        String opName = OperatorSpi.getOperatorAlias(operatorClass);
        MetadataElement targetNodeME = new MetadataElement(String.format("node.%d", nodeElementCount));
        targetGraphME.addElement(targetNodeME);
        targetNodeME.addAttribute(new MetadataAttribute("id", ProductData.createInstance((String)opId), false));
        targetNodeME.addAttribute(new MetadataAttribute("operator", ProductData.createInstance((String)opName), false));
        ModuleMetadata moduleMetadata = this.operatorSpi.getModuleMetadata();
        if (moduleMetadata != null) {
            ProductData moduleName = ProductData.createInstance((String)moduleMetadata.getDisplayName());
            targetNodeME.addAttribute(new MetadataAttribute("moduleName", moduleName, false));
            ProductData moduleVersion = ProductData.createInstance((String)moduleMetadata.getVersion());
            targetNodeME.addAttribute(new MetadataAttribute("moduleVersion", moduleVersion, false));
        }
        if ((operatorSpi = (operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry()).getOperatorSpi(opName)) != null) {
            OperatorDescriptor operatorDescriptor = operatorSpi.getOperatorDescriptor();
            if (operatorDescriptor.getDescription() != null) {
                ProductData purposeValue = ProductData.createInstance((String)operatorDescriptor.getDescription());
                targetNodeME.addAttribute(new MetadataAttribute("purpose", purposeValue, false));
            }
            if (operatorDescriptor.getAuthors() != null) {
                ProductData authorsValue = ProductData.createInstance((String)operatorDescriptor.getAuthors());
                targetNodeME.addAttribute(new MetadataAttribute("authors", authorsValue, false));
            }
            if (operatorDescriptor.getVersion() != null) {
                ProductData opVersionValue = ProductData.createInstance((String)operatorDescriptor.getVersion());
                targetNodeME.addAttribute(new MetadataAttribute("version", opVersionValue, false));
            }
            if (operatorDescriptor.getCopyright() != null) {
                ProductData copyrightValue = ProductData.createInstance((String)operatorDescriptor.getCopyright());
                targetNodeME.addAttribute(new MetadataAttribute("copyright", copyrightValue, false));
            }
        }
        ProductData processingTime = ProductData.createInstance((String)DATETIME_OUTPUT_FORMAT.format(new Date()));
        targetNodeME.addAttribute(new MetadataAttribute("processingTime", processingTime, false));
        ArrayList<MetadataAttribute> sourceAttributeList = new ArrayList<MetadataAttribute>(context.sourceProductList.size() * 2);
        for (Product product : context.sourceProductList) {
            String sourceNodeId;
            String sourceId = context.getSourceProductId(product);
            if (sourceId == null) {
                throw new OperatorException(this.formatExceptionMessage("Source product not found: " + product.getName(), new Object[0]));
            }
            if (product.getFileLocation() != null) {
                sourceNodeId = product.getFileLocation().toURI().toASCIIString();
            } else if (product.getProductReader() instanceof OperatorProductReader) {
                OperatorProductReader productReader = (OperatorProductReader)product.getProductReader();
                this.convertOperatorContextToMetadata(productReader.getOperatorContext(), targetGraphME);
                sourceNodeId = productReader.getOperatorContext().getId();
            } else {
                sourceNodeId = "product:" + product.getDisplayName();
            }
            MetadataAttribute sourceAttribute = new MetadataAttribute(sourceId, ProductData.createInstance((String)sourceNodeId), false);
            sourceAttributeList.add(sourceAttribute);
        }
        MetadataElement targetSourcesME = new MetadataElement("sources");
        Collections.sort(sourceAttributeList, (ma1, ma2) -> ma1.getName().compareTo(ma2.getName()));
        for (MetadataAttribute sourceAttribute : sourceAttributeList) {
            targetSourcesME.addAttribute(sourceAttribute);
        }
        targetNodeME.addElement(targetSourcesME);
        DefaultDomConverter defaultDomConverter = new DefaultDomConverter(operatorClass, (PropertyDescriptorFactory)new ParameterDescriptorFactory(this.sourceProductMap));
        XppDomElement parametersDom = new XppDomElement("parameters");
        try {
            defaultDomConverter.convertValueToDom((Object)context.operator, (DomElement)parametersDom);
        }
        catch (ConversionException e) {
            e.printStackTrace();
        }
        MetadataElement targetParametersME = new MetadataElement("parameters");
        OperatorContext.addDomToMetadata((DomElement)parametersDom, targetParametersME);
        targetNodeME.addElement(targetParametersME);
    }

    private static void addDomToMetadata(DomElement parentDE, MetadataElement parentME) {
        HashMap<String, ArrayList<DomElement>> map = new HashMap<String, ArrayList<DomElement>>(parentDE.getChildCount() + 5);
        for (DomElement childDE : (DomElement[])parentDE.getChildren()) {
            String name = childDE.getName();
            ArrayList<DomElement> elementList = (ArrayList<DomElement>)map.get(name);
            if (elementList == null) {
                elementList = new ArrayList<DomElement>(3);
                map.put(name, elementList);
            }
            elementList.add(childDE);
        }
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            List elementList = (List)entry.getValue();
            if (elementList.size() > 1) {
                for (int i = 0; i < elementList.size(); ++i) {
                    OperatorContext.addDomToMetadata((DomElement)elementList.get(i), name + '.' + i, parentME);
                }
                continue;
            }
            OperatorContext.addDomToMetadata((DomElement)elementList.get(0), name, parentME);
        }
    }

    private static void addDomToMetadata(DomElement childDE, String name, MetadataElement parentME) {
        if (childDE.getChildCount() > 0 || childDE.getAttributeNames().length > 0) {
            MetadataElement childME = new MetadataElement(name);
            OperatorContext.addDomToMetadata(childDE, childME);
            parentME.addElement(childME);
            if (childDE.getAttributeNames().length != 0) {
                String[] attributeNames;
                for (String attributeName : attributeNames = childDE.getAttributeNames()) {
                    String attributeValue = childDE.getAttribute(attributeName);
                    ProductData valueMEAtrr = ProductData.createInstance((String)attributeValue);
                    MetadataAttribute mdAttribute = new MetadataAttribute(attributeName, valueMEAtrr, true);
                    childME.addAttribute(mdAttribute);
                }
            }
        } else {
            String valueDE = childDE.getValue();
            if (valueDE == null) {
                valueDE = "";
            }
            ProductData valueME = ProductData.createInstance((String)valueDE);
            MetadataAttribute attribute = new MetadataAttribute(name, valueME, true);
            parentME.addAttribute(attribute);
        }
    }

    private void initTargetImages() {
        if (this.targetProduct.getPreferredTileSize() == null) {
            this.targetProduct.setPreferredTileSize(this.getPreferredTileSize());
        }
        Band[] targetBands = this.targetProduct.getBands();
        Object[][] locks = null;
        if (this.operatorMustComputeTileStack()) {
            Dimension tileSize = this.targetProduct.getPreferredTileSize();
            int width = this.targetProduct.getSceneRasterWidth();
            int height = this.targetProduct.getSceneRasterHeight();
            locks = OperatorImageTileStack.createLocks(width, height, tileSize);
        }
        this.targetImageMap = new HashMap<Band, OperatorImage>(targetBands.length * 2);
        for (Band targetBand : targetBands) {
            WriteOp writer;
            ProductWriter productWriter;
            if (OperatorContext.isRegularBand(targetBand)) {
                OperatorImage opImage = this.getOwnedOperatorImage(targetBand);
                if (opImage == null) {
                    OperatorImage image = this.operatorMustComputeTileStack() ? new OperatorImageTileStack(targetBand, this, locks) : new OperatorImage(targetBand, this);
                    this.targetImageMap.put(targetBand, image);
                    if (targetBand.isSourceImageSet()) continue;
                    targetBand.setSourceImage((RenderedImage)((Object)image));
                    continue;
                }
                targetBand.getSourceImage().reset();
                this.targetImageMap.put(targetBand, opImage);
                continue;
            }
            final Operator operator = this.getOperator();
            if (!(operator instanceof WriteOp) || (productWriter = ProductIO.getProductWriter((String)(writer = (WriteOp)operator).getFormatName())) == null || !productWriter.shouldWrite((ProductNode)targetBand)) continue;
            this.targetImageMap.put(targetBand, new OperatorImage(targetBand, this){

                @Override
                protected void computeRect(PlanarImage[] ignored, WritableRaster tile, Rectangle destRect) {
                    OperatorContext.this.executeOperator(ProgressMonitor.NULL);
                    Band targetBand = this.getTargetBand();
                    tile.setRect(targetBand.getGeophysicalImage().getData(destRect));
                    TileImpl targetTile = new TileImpl((RasterDataNode)targetBand, tile, destRect, false);
                    operator.computeTile(targetBand, targetTile, ProgressMonitor.NULL);
                }
            });
        }
    }

    private OperatorImage getOwnedOperatorImage(Band targetBand) {
        if (!targetBand.isSourceImageSet()) {
            return null;
        }
        RenderedImage renderedImage = targetBand.getSourceImage().getImage(0);
        if (!(renderedImage instanceof OperatorImage)) {
            return null;
        }
        OperatorImage operatorImage = (OperatorImage)((Object)renderedImage);
        if (this != operatorImage.getOperatorContext()) {
            return null;
        }
        return operatorImage;
    }

    private Dimension getPreferredTileSize() {
        Dimension tileSize = null;
        for (Product sourceProduct : this.sourceProductList) {
            if (sourceProduct.getPreferredTileSize() == null || sourceProduct.getSceneRasterWidth() != this.targetProduct.getSceneRasterWidth() || sourceProduct.getSceneRasterHeight() != this.targetProduct.getSceneRasterHeight()) continue;
            tileSize = sourceProduct.getPreferredTileSize();
            break;
        }
        if (tileSize == null) {
            tileSize = JAIUtils.computePreferredTileSize((int)this.targetProduct.getSceneRasterWidth(), (int)this.targetProduct.getSceneRasterHeight(), (int)4);
        }
        return tileSize;
    }

    public static boolean isRegularBand(Band targetBand) {
        return targetBand.getClass() == Band.class;
    }

    private void initTargetProduct() throws OperatorException {
        Class<?> operatorClass = this.operator.getClass();
        this.initTargetProduct(operatorClass);
        if (this.targetProduct == null) {
            String message = this.formatExceptionMessage("No target product set.", new Object[0]);
            throw new OperatorException(message);
        }
        if (this.targetProduct.getProductReader() == null) {
            this.targetProduct.setProductReader((ProductReader)new OperatorProductReader(this));
        }
        if (GPF.KEY_TILE_SIZE.isCompatibleValue(this.renderingHints.get(GPF.KEY_TILE_SIZE))) {
            this.targetProduct.setPreferredTileSize((Dimension)this.renderingHints.get(GPF.KEY_TILE_SIZE));
        }
    }

    private void initTargetProduct(Class<? extends Operator> operatorClass) {
        Class<? extends Operator> superClass = operatorClass.getSuperclass();
        if (superClass != null && !superClass.equals(Operator.class)) {
            this.initTargetProduct(superClass);
        }
        for (Field declaredField : operatorClass.getDeclaredFields()) {
            TargetProduct targetProductAnnotation = declaredField.getAnnotation(TargetProduct.class);
            if (targetProductAnnotation == null) continue;
            if (!declaredField.getType().equals(Product.class)) {
                String msg = this.formatExceptionMessage("Field '%s' annotated as target product is not of type '%s'.", declaredField.getName(), Product.class);
                throw new OperatorException(msg);
            }
            Product targetProduct = (Product)this.getOperatorFieldValue(declaredField);
            if (targetProduct != null) {
                this.targetProduct = targetProduct;
                continue;
            }
            if (this.targetProduct != null) {
                this.setOperatorFieldValue(declaredField, this.targetProduct);
                continue;
            }
            String message = this.formatExceptionMessage("No target product set.", new Object[0]);
            throw new OperatorException(message);
        }
    }

    private void initTargetProperties(Class<? extends Operator> operatorClass) throws OperatorException {
        Class<? extends Operator> superClass = operatorClass.getSuperclass();
        if (superClass != null && !superClass.equals(Operator.class)) {
            this.initTargetProperties(superClass);
        }
        Field[] declaredFields = operatorClass.getDeclaredFields();
        HashMap<String, Object> localTargetPropertyMap = new HashMap<String, Object>();
        for (Field declaredField : declaredFields) {
            TargetProperty targetPropertyAnnotation = declaredField.getAnnotation(TargetProperty.class);
            if (targetPropertyAnnotation == null) continue;
            Object propertyValue = this.getOperatorFieldValue(declaredField);
            String fieldName = declaredField.getName();
            if (localTargetPropertyMap.containsKey(fieldName)) {
                String message = this.formatExceptionMessage("Name of field '%s' is already used as target property alias.", fieldName);
                throw new OperatorException(message);
            }
            localTargetPropertyMap.put(fieldName, propertyValue);
            if (targetPropertyAnnotation.alias().isEmpty()) continue;
            String aliasName = targetPropertyAnnotation.alias();
            if (localTargetPropertyMap.containsKey(aliasName)) {
                String message = this.formatExceptionMessage("Alias of field '%s' is already used by another target property.", aliasName);
                throw new OperatorException(message);
            }
            localTargetPropertyMap.put(aliasName, propertyValue);
        }
        this.targetPropertyMap.putAll(localTargetPropertyMap);
    }

    private void initSourceProductFields() throws OperatorException {
        this.initSourceProductFields(this.operator.getClass());
    }

    private void initSourceProductFields(Class<? extends Operator> operatorClass) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = operatorClass.getDeclaredFields()) {
            SourceProducts sourceProductsAnnotation;
            SourceProduct sourceProductAnnotation = declaredField.getAnnotation(SourceProduct.class);
            if (sourceProductAnnotation != null) {
                this.processSourceProductField(declaredField, sourceProductAnnotation);
            }
            if ((sourceProductsAnnotation = declaredField.getAnnotation(SourceProducts.class)) == null) continue;
            this.processSourceProductsField(declaredField, sourceProductsAnnotation);
        }
        Class<? extends Operator> superClass = operatorClass.getSuperclass();
        if (superClass != null && !superClass.equals(Operator.class)) {
            this.initSourceProductFields(superClass);
        }
    }

    private void processSourceProductField(Field declaredField, SourceProduct sourceProductAnnotation) throws OperatorException {
        if (declaredField.getType().equals(Product.class)) {
            String productMapName = declaredField.getName();
            Product sourceProduct = this.getSourceProduct(productMapName);
            if (sourceProduct == null) {
                productMapName = sourceProductAnnotation.alias();
                sourceProduct = this.getSourceProduct(productMapName);
            }
            if (sourceProduct != null) {
                this.validateSourceProduct(declaredField.getName(), sourceProduct, sourceProductAnnotation.type(), sourceProductAnnotation.bands());
                this.setSourceProductFieldValue(declaredField, sourceProduct);
                this.setSourceProduct(productMapName, sourceProduct);
            } else {
                sourceProduct = this.getSourceProductFieldValue(declaredField);
                if (sourceProduct != null) {
                    this.setSourceProduct(declaredField.getName(), sourceProduct);
                } else if (!sourceProductAnnotation.optional()) {
                    String text = "Mandatory source product (field '%s') not set.";
                    String msg = this.formatExceptionMessage(text, declaredField.getName());
                    throw new OperatorException(msg);
                }
            }
        } else {
            String text = "A source product (field '%s') must be of type '%s'.";
            String msg = this.formatExceptionMessage(text, declaredField.getName(), Product.class.getName());
            throw new OperatorException(msg);
        }
    }

    private void processSourceProductsField(Field declaredField, SourceProducts sourceProductsAnnotation) throws OperatorException {
        if (declaredField.getType().equals(Product[].class)) {
            Product[] sourceProducts = this.getSourceProductsFieldValue(declaredField);
            if (sourceProducts != null) {
                for (int i = 0; i < sourceProducts.length; ++i) {
                    Product sourceProduct = sourceProducts[i];
                    this.setSourceProduct("sourceProduct." + (i + 1), sourceProduct);
                    this.setSourceProduct("sourceProduct" + (i + 1), sourceProduct);
                }
            }
            if ((sourceProducts = this.getSourceProducts()).length > 0) {
                this.setSourceProductsFieldValue(declaredField, this.getUnnamedProducts());
            }
            if (sourceProductsAnnotation.count() < 0) {
                if (sourceProducts.length == 0) {
                    String msg = this.formatExceptionMessage("At least a single source product expected.", new Object[0]);
                    throw new OperatorException(msg);
                }
            } else if (sourceProductsAnnotation.count() > 0 && sourceProductsAnnotation.count() != sourceProducts.length) {
                String text = "Wrong number of source products. Required %d, found %d.";
                String msg = this.formatExceptionMessage(text, sourceProductsAnnotation.count(), sourceProducts.length);
                throw new OperatorException(msg);
            }
            for (Product sourceProduct : sourceProducts) {
                this.validateSourceProduct(declaredField.getName(), sourceProduct, sourceProductsAnnotation.type(), sourceProductsAnnotation.bands());
            }
        } else {
            String text = "Source products (field '%s') must be of type '%s'.";
            String msg = this.formatExceptionMessage(text, declaredField.getName(), Product[].class.getName());
            throw new OperatorException(msg);
        }
    }

    private Product[] getUnnamedProducts() {
        Field[] sourceProductFields;
        ArrayList<Product> srcProductList = new ArrayList<Product>(this.sourceProductList.size());
        srcProductList.addAll(this.sourceProductList);
        for (Field sourceProductField : sourceProductFields = OperatorContext.getAnnotatedSourceProductFields(this.operator)) {
            SourceProduct annotation;
            Product product = this.sourceProductMap.get(sourceProductField.getName());
            if (product != null) {
                srcProductList.remove(product);
            }
            if ((product = this.sourceProductMap.get((annotation = sourceProductField.getAnnotation(SourceProduct.class)).alias())) == null) continue;
            srcProductList.remove(product);
        }
        return srcProductList.toArray(new Product[srcProductList.size()]);
    }

    private static Field[] getAnnotatedSourceProductFields(Operator operator1) {
        Field[] declaredFields = operator1.getClass().getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field declaredField : declaredFields) {
            SourceProduct sourceProductAnnotation = declaredField.getAnnotation(SourceProduct.class);
            if (sourceProductAnnotation == null) continue;
            fieldList.add(declaredField);
        }
        return fieldList.toArray(new Field[fieldList.size()]);
    }

    private Product getSourceProductFieldValue(Field declaredField) throws OperatorException {
        return (Product)this.getOperatorFieldValue(declaredField);
    }

    private void setSourceProductFieldValue(Field declaredField, Product sourceProduct) throws OperatorException {
        this.setOperatorFieldValue(declaredField, sourceProduct);
    }

    private Product[] getSourceProductsFieldValue(Field declaredField) throws OperatorException {
        return (Product[])this.getOperatorFieldValue(declaredField);
    }

    private void setSourceProductsFieldValue(Field declaredField, Product[] sourceProducts) throws OperatorException {
        this.setOperatorFieldValue(declaredField, sourceProducts);
    }

    private void validateSourceProduct(String fieldName, Product sourceProduct, String typeRegExp, String[] bandNames) throws OperatorException {
        String productType;
        if (!(typeRegExp.isEmpty() || typeRegExp.equalsIgnoreCase(productType = sourceProduct.getProductType()) || Pattern.matches(typeRegExp, productType))) {
            String msg = this.formatExceptionMessage("A source product (field '%s') of type '%s' does not match type '%s'", fieldName, productType, typeRegExp);
            throw new OperatorException(msg);
        }
        if (bandNames.length != 0) {
            for (String bandName : bandNames) {
                if (sourceProduct.containsBand(bandName)) continue;
                String msg = this.formatExceptionMessage("A source product (field '%s') does not contain the band '%s'", fieldName, bandName);
                throw new OperatorException(msg);
            }
        }
    }

    private Object getOperatorFieldValue(Field declaredField) throws OperatorException {
        boolean oldState = declaredField.isAccessible();
        try {
            declaredField.setAccessible(true);
            try {
                Object object = declaredField.get(this.getOperator());
                return object;
            }
            catch (IllegalAccessException e) {
                String msg = this.formatExceptionMessage("Unable to get declared field '%s'.", declaredField.getName());
                throw new OperatorException(msg, e);
            }
        }
        finally {
            declaredField.setAccessible(oldState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOperatorFieldValue(Field declaredField, Object value) throws OperatorException {
        boolean oldState = declaredField.isAccessible();
        try {
            declaredField.setAccessible(true);
            try {
                declaredField.set(this.getOperator(), value);
            }
            catch (IllegalAccessException e) {
                String msg = this.formatExceptionMessage("Unable to set declared field '%s'", declaredField.getName());
                throw new OperatorException(msg, e);
            }
        }
        finally {
            declaredField.setAccessible(oldState);
        }
    }

    public void injectConfiguration() throws OperatorException {
        if (this.configuration != null) {
            try {
                this.configureOperator(this.configuration);
            }
            catch (OperatorException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new OperatorException(this.formatExceptionMessage("%s", t.getMessage()), t);
            }
        }
    }

    private void configureOperator(OperatorConfiguration operatorConfiguration) throws ValidationException, ConversionException {
        OperatorDescriptor operatorDescriptor = this.getOperatorSpi().getOperatorDescriptor();
        ParameterDescriptorFactory descriptorFactory = new ParameterDescriptorFactory(this.sourceProductMap);
        PropertySetDescriptor propertySetDescriptor = PropertySetDescriptorFactory.createForOperator(operatorDescriptor, descriptorFactory.getSourceProductMap());
        Class<? extends Operator> operatorType = operatorDescriptor.getOperatorClass();
        DefaultDomConverter domConverter = new DefaultDomConverter(operatorType, (PropertyDescriptorFactory)descriptorFactory, propertySetDescriptor);
        domConverter.convertDomToValue(operatorConfiguration.getConfiguration(), (Object)this.getParameterSet());
        Set<OperatorConfiguration.Reference> referenceSet = operatorConfiguration.getReferenceSet();
        for (OperatorConfiguration.Reference reference : referenceSet) {
            Property property = this.getParameterSet().getProperty(reference.getParameterName());
            property.setValue(reference.getValue());
        }
    }

    void updatePropertyDescriptors() throws OperatorException {
        Property[] properties;
        for (Property property : properties = this.getParameterSet().getProperties()) {
            PropertyDescriptor descriptor = property.getDescriptor();
            if (descriptor.getAttribute("rasterDataNodeType") == null) continue;
            Product sourceProduct = this.sourceProductList.get(0);
            if (sourceProduct == null) {
                throw new OperatorException(this.formatExceptionMessage("No source product.", new Object[0]));
            }
            Object object = descriptor.getAttribute("rasterDataNodeType");
            Class rasterDataNodeType = (Class)object;
            boolean includeEmptyValue = !descriptor.isNotNull() && !descriptor.isNotEmpty() && !descriptor.getType().isArray();
            Object[] names = RasterDataNodeValues.getNames(sourceProduct, rasterDataNodeType, includeEmptyValue);
            ValueSet valueSet = new ValueSet(names);
            descriptor.setValueSet(valueSet);
        }
    }

    private String formatExceptionMessage(String format, Object ... args) {
        Object[] allArgs = new Object[args.length + 1];
        allArgs[0] = this.operator.getClass().getSimpleName();
        System.arraycopy(args, 0, allArgs, 1, allArgs.length - 1);
        return String.format("Operator '%s': " + format, allArgs);
    }

    private void startTileComputationObservation() {
        String tchClass;
        if (tileComputationObserver == null && (tchClass = Config.instance().preferences().get("snap.gpf.tileComputationObserver", null)) != null) {
            try {
                tileComputationObserver = (TileComputationObserver)Class.forName(tchClass).newInstance();
                tileComputationObserver.setLogger(this.logger);
                tileComputationObserver.start();
            }
            catch (Throwable t) {
                this.getLogger().warning("Failed to instantiate tile computation observer: " + t.getMessage());
            }
        }
    }

    public void stopTileComputationObservation() {
        if (tileComputationObserver != null) {
            tileComputationObserver.stop();
            tileComputationObserver = null;
        }
    }

    public void fireTileComputed(OperatorImage operatorImage, Rectangle destRect, long startNanos) {
        if (tileComputationObserver != null) {
            long endNanos = System.nanoTime();
            int tileX = operatorImage.XToTileX(destRect.x);
            int tileY = operatorImage.YToTileY(destRect.y);
            long nettoNanos = this.getNettoTime();
            tileComputationObserver.tileComputed(new TileComputationEvent(operatorImage, tileX, tileY, startNanos, endNanos, nettoNanos));
        }
    }

    public void startWatch() {
        if (tileComputationObserver != null) {
            this.nettoWatch.get().start();
        }
    }

    public void stopWatch() {
        if (tileComputationObserver != null) {
            this.nettoWatch.get().stop();
        }
    }

    public void suspendWatch() {
        if (tileComputationObserver != null) {
            this.nettoWatch.get().suspend();
        }
    }

    public void resumeWatch() {
        if (tileComputationObserver != null) {
            this.nettoWatch.get().resume();
        }
    }

    public long getNettoTime() {
        return this.nettoWatch.get().getTime();
    }

    boolean isComputingImageOf(Band band) {
        if (band.isSourceImageSet()) {
            RenderedImage sourceImage = band.getSourceImage().getImage(0);
            OperatorImage targetImage = this.getTargetImage(band);
            return targetImage == sourceImage;
        }
        return false;
    }

    public boolean requiresAllBands() {
        return this.requiresAllBands;
    }

    public void setRequiresAllBands(boolean requiresAllBands) {
        this.requiresAllBands = requiresAllBands;
    }

    public synchronized void executeOperator(ProgressMonitor pm) {
        if (!this.executed) {
            this.getOperator().doExecute(pm);
            this.executed = true;
        }
    }

    static {
        DATETIME_OUTPUT_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private static final class SuspendableStopWatch {
        private long startTime = -1L;
        private long stopTime = -1L;

        private SuspendableStopWatch() {
        }

        public void start() {
            this.stopTime = -1L;
            this.startTime = System.nanoTime();
        }

        public void stop() {
            this.stopTime = System.nanoTime();
        }

        public void suspend() {
            this.stopTime = System.nanoTime();
        }

        public void resume() {
            this.startTime += System.nanoTime() - this.stopTime;
            this.stopTime = -1L;
        }

        public long getTime() {
            return this.stopTime - this.startTime;
        }
    }
}

