/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.esa.snap.rcp.statistics.ScatterPlotPanel;
import org.esa.snap.ui.io.CsvEncoder;
import org.esa.snap.ui.io.TableModelCsvEncoder;
import org.opengis.feature.Property;

class ScatterPlotTableModel
extends AbstractTableModel
implements CsvEncoder {
    private static final String REF_SUFFIX = "_ref";
    private final List<String> colNames;
    private final Map<Integer, Integer> propertyIndices;
    private final ScatterPlotPanel.ComputedData[] computedDatas;

    public ScatterPlotTableModel(String rasterName, String correlativDataName, ScatterPlotPanel.ComputedData[] computedDatas) {
        this.computedDatas = computedDatas;
        this.colNames = new ArrayList<String>();
        this.colNames.add("pixel_no");
        this.colNames.add("pixel_x");
        this.colNames.add("pixel_y");
        this.colNames.add("latitude");
        this.colNames.add("longitude");
        this.colNames.add(rasterName + "_mean");
        this.colNames.add(rasterName + "_sigma");
        this.colNames.add(correlativDataName + REF_SUFFIX);
        int colStart = 8;
        this.propertyIndices = new HashMap<Integer, Integer>();
        int validPropertyCount = 0;
        Collection<Property> props = computedDatas[0].featureProperties;
        Property[] properties = props.toArray(new Property[props.size()]);
        for (int i = 0; i < properties.length; ++i) {
            String name = properties[i].getName().toString();
            if (correlativDataName.equals(name)) continue;
            this.colNames.add(name + REF_SUFFIX);
            this.propertyIndices.put(8 + validPropertyCount, i);
            ++validPropertyCount;
        }
    }

    public void encodeCsv(Writer writer) throws IOException {
        new TableModelCsvEncoder((TableModel)this).encodeCsv(writer);
    }

    @Override
    public int getRowCount() {
        return this.computedDatas.length;
    }

    @Override
    public int getColumnCount() {
        return this.colNames.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.colNames.get(column);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return rowIndex + 1;
        }
        if (columnIndex == 1) {
            return Float.valueOf(this.computedDatas[rowIndex].x);
        }
        if (columnIndex == 2) {
            return Float.valueOf(this.computedDatas[rowIndex].y);
        }
        if (columnIndex == 3) {
            return Float.valueOf(this.computedDatas[rowIndex].lat);
        }
        if (columnIndex == 4) {
            return Float.valueOf(this.computedDatas[rowIndex].lon);
        }
        if (columnIndex == 5) {
            return Float.valueOf(this.computedDatas[rowIndex].rasterMean);
        }
        if (columnIndex == 6) {
            return Float.valueOf(this.computedDatas[rowIndex].rasterSigma);
        }
        if (columnIndex == 7) {
            return Float.valueOf(this.computedDatas[rowIndex].correlativeData);
        }
        if (columnIndex < this.getColumnCount()) {
            Collection<Property> propColl = this.computedDatas[rowIndex].featureProperties;
            Property[] properties = propColl.toArray(new Property[propColl.size()]);
            Integer propertyIndex = this.propertyIndices.get(columnIndex);
            return properties[propertyIndex].getValue();
        }
        return null;
    }

    public String toCVS() {
        StringWriter sw = new StringWriter();
        try {
            this.encodeCsv(sw);
            sw.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return sw.toString();
    }
}

