/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.statistics;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.LayerListener;
import com.bc.ceres.glayer.support.AbstractLayerListener;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.BorderLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.statistics.PagePanel;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.VectorDataLayer;
import org.esa.snap.ui.product.VectorDataLayerFilterFactory;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

public abstract class AbstractStatisticsTopComponent
extends TopComponent
implements HelpCtx.Provider {
    private PagePanel pagePanel;
    private Product product;
    private final PagePanelLL pagePanelLL;
    private final SelectionChangeListener pagePanelSCL;
    private final PagePanelProductHandler pagePanelProductListener = new PagePanelProductHandler();
    private final PagePanelProductSceneViewHandler pagePanelProductSceneViewListener = new PagePanelProductSceneViewHandler();
    private final PagePanelProductRemovedListener pagePanelProductRemovedListener = new PagePanelProductRemovedListener();

    protected AbstractStatisticsTopComponent() {
        this.pagePanelLL = new PagePanelLL();
        this.pagePanelSCL = new PagePanelSCL();
        this.initComponent();
    }

    public void initComponent() {
        this.setLayout(new BorderLayout());
        this.pagePanel = this.createPagePanel();
        this.pagePanel.initComponents();
        this.setCurrentSelection();
        this.add(this.pagePanel, "Center");
    }

    protected abstract PagePanel createPagePanel();

    public abstract HelpCtx getHelpCtx();

    public void componentShowing() {
        SnapApp snapApp = SnapApp.getDefault();
        snapApp.getProductManager().addListener((ProductManager.Listener)this.pagePanelProductRemovedListener);
        snapApp.getSelectionSupport(ProductNode.class).addHandler(this.pagePanelProductListener);
        snapApp.getSelectionSupport(ProductSceneView.class).addHandler(this.pagePanelProductSceneViewListener);
        ProductSceneView productSceneView = snapApp.getSelectedProductSceneView();
        this.addViewListener(productSceneView);
        this.setCurrentSelection();
        this.transferProductNodeListener(null, this.product);
    }

    public void componentHidden() {
        this.transferProductNodeListener(this.product, null);
        SnapApp snapApp = SnapApp.getDefault();
        snapApp.getProductManager().removeListener((ProductManager.Listener)this.pagePanelProductRemovedListener);
        snapApp.getSelectionSupport(ProductNode.class).removeHandler(this.pagePanelProductListener);
        snapApp.getSelectionSupport(ProductSceneView.class).removeHandler(this.pagePanelProductSceneViewListener);
        this.removeViewListener(snapApp.getSelectedProductSceneView());
    }

    private void addViewListener(ProductSceneView view) {
        if (view != null) {
            view.getRootLayer().addListener((LayerListener)this.pagePanelLL);
            view.getFigureEditor().addSelectionChangeListener(this.pagePanelSCL);
        }
    }

    private void removeViewListener(ProductSceneView view) {
        if (view != null) {
            view.getRootLayer().removeListener((LayerListener)this.pagePanelLL);
            view.getFigureEditor().removeSelectionChangeListener(this.pagePanelSCL);
        }
    }

    private void transferProductNodeListener(Product oldProduct, Product newProduct) {
        if (oldProduct != newProduct) {
            if (oldProduct != null) {
                oldProduct.removeProductNodeListener((ProductNodeListener)this.pagePanel);
            }
            if (newProduct != null) {
                newProduct.addProductNodeListener((ProductNodeListener)this.pagePanel);
            }
        }
    }

    private void updateTitle() {
        this.setDisplayName(this.pagePanel.getTitle());
    }

    void setCurrentSelection() {
        Product product = null;
        RasterDataNode raster = null;
        VectorDataNode vectorDataNode = null;
        ProductNode selectedNode = SnapApp.getDefault().getSelectedProductNode(SnapApp.SelectionSourceHint.EXPLORER);
        if (selectedNode != null && selectedNode.getProduct() != null) {
            product = selectedNode.getProduct();
        }
        if (selectedNode instanceof RasterDataNode) {
            raster = (RasterDataNode)selectedNode;
        } else if (selectedNode instanceof VectorDataNode) {
            vectorDataNode = (VectorDataNode)selectedNode;
        }
        this.selectionChanged(product, raster, vectorDataNode);
    }

    private void selectionChanged(final Product product, final RasterDataNode raster, final VectorDataNode vectorDataNode) {
        this.product = product;
        this.runInEDT(new Runnable(){

            @Override
            public void run() {
                AbstractStatisticsTopComponent.this.pagePanel.selectionChanged(product, raster, vectorDataNode);
                AbstractStatisticsTopComponent.this.updateTitle();
            }
        });
    }

    private void runInEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private class PagePanelSCL
    implements SelectionChangeListener {
        private PagePanelSCL() {
        }

        public void selectionChanged(SelectionChangeEvent event) {
            AbstractStatisticsTopComponent.this.pagePanel.handleLayerContentChanged();
        }

        public void selectionContextChanged(SelectionChangeEvent event) {
            AbstractStatisticsTopComponent.this.pagePanel.handleLayerContentChanged();
        }
    }

    private class PagePanelLL
    extends AbstractLayerListener {
        private PagePanelLL() {
        }

        public void handleLayerDataChanged(Layer layer, Rectangle2D modelRegion) {
            AbstractStatisticsTopComponent.this.pagePanel.handleLayerContentChanged();
        }
    }

    private class PagePanelProductSceneViewHandler
    implements SelectionSupport.Handler<ProductSceneView> {
        private PagePanelProductSceneViewHandler() {
        }

        @Override
        public void selectionChange(ProductSceneView oldValue, ProductSceneView newValue) {
            if (oldValue != null) {
                AbstractStatisticsTopComponent.this.removeViewListener(oldValue);
            }
            if (newValue != null) {
                AbstractStatisticsTopComponent.this.addViewListener(newValue);
                VectorDataNode vectorDataNode = this.getVectorDataNode(newValue);
                AbstractStatisticsTopComponent.this.selectionChanged(newValue.getRaster().getProduct(), newValue.getRaster(), vectorDataNode);
            }
        }

        private VectorDataNode getVectorDataNode(ProductSceneView view) {
            Layer rootLayer = view.getRootLayer();
            Layer layer = LayerUtils.getChildLayer((Layer)rootLayer, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (LayerFilter)VectorDataLayerFilterFactory.createGeometryFilter());
            VectorDataNode vectorDataNode = null;
            if (layer instanceof VectorDataLayer) {
                VectorDataLayer vdl = (VectorDataLayer)layer;
                vectorDataNode = vdl.getVectorDataNode();
            }
            return vectorDataNode;
        }
    }

    private class PagePanelProductRemovedListener
    implements ProductManager.Listener {
        private PagePanelProductRemovedListener() {
        }

        public void productAdded(ProductManager.Event event) {
        }

        public void productRemoved(ProductManager.Event event) {
            AbstractStatisticsTopComponent.this.selectionChanged(null, null, null);
        }
    }

    private class PagePanelProductHandler
    implements SelectionSupport.Handler<ProductNode> {
        private PagePanelProductHandler() {
        }

        @Override
        public void selectionChange(ProductNode oldValue, ProductNode newValue) {
            if (newValue != null) {
                Product product;
                RasterDataNode raster = null;
                if (newValue instanceof RasterDataNode) {
                    raster = (RasterDataNode)newValue;
                }
                VectorDataNode vector = null;
                if (newValue instanceof VectorDataNode) {
                    vector = (VectorDataNode)newValue;
                    ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
                    if (sceneView != null) {
                        raster = sceneView.getRaster();
                    }
                }
                if ((product = newValue.getProduct()) != null) {
                    AbstractStatisticsTopComponent.this.selectionChanged(product, raster, vector);
                }
            }
        }
    }
}

