/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.preferences.general;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.snap.rcp.preferences.DefaultConfigController;
import org.esa.snap.rcp.preferences.Preference;
import org.esa.snap.rcp.preferences.PreferenceUtils;
import org.openide.util.HelpCtx;

public final class MaskLayerController
extends DefaultConfigController {
    public static final String PREFERENCE_KEY_MASK_COLOR = "mask.color";
    public static final String PREFERENCE_KEY_MASK_TRANSPARENCY = "mask.transparency";

    @Override
    protected PropertySet createPropertySet() {
        return this.createPropertySet(new MaskBean());
    }

    @Override
    protected JPanel createPanel(BindingContext context) {
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTablePadding(new Insets(4, 10, 0, 0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setColumnWeightX(1, Double.valueOf(1.0));
        JPanel pageUI = new JPanel((LayoutManager)tableLayout);
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        Property maskOverlayColor = context.getPropertySet().getProperty(PREFERENCE_KEY_MASK_COLOR);
        Property maskOverlayTransparency = context.getPropertySet().getProperty(PREFERENCE_KEY_MASK_TRANSPARENCY);
        JComponent[] maskOverlayColorComponents = PreferenceUtils.createColorComponents(maskOverlayColor);
        JComponent[] maskOverlayTransparencyComponents = registry.findPropertyEditor(maskOverlayTransparency.getDescriptor()).createComponents(maskOverlayTransparency.getDescriptor(), context);
        pageUI.add(maskOverlayColorComponents[0]);
        pageUI.add(maskOverlayColorComponents[1]);
        pageUI.add(maskOverlayTransparencyComponents[1]);
        pageUI.add(maskOverlayTransparencyComponents[0]);
        pageUI.add(tableLayout.createVerticalSpacer());
        JPanel parent = new JPanel(new BorderLayout());
        parent.add((Component)pageUI, "Center");
        parent.add(Box.createHorizontalStrut(100), "East");
        return parent;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("layer");
    }

    static class MaskBean {
        @Preference(label="Default mask overlay colour", key="mask.color")
        Color maskOverlayColor = Color.RED;
        @Preference(label="Default mask overlay transparency", key="mask.transparency", interval="[0.0,1.0]")
        double maskOverlayTransparency = 0.5;

        MaskBean() {
        }
    }
}

