/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.nodes;

import com.bc.ceres.core.Assert;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.rcp.nodes.Bundle;

public class UndoableProductNodeDeletion<T extends ProductNode>
extends AbstractUndoableEdit {
    private ProductNodeGroup<T> productNodeGroup;
    private T productNode;
    private final int index;

    public UndoableProductNodeDeletion(ProductNodeGroup<T> productNodeGroup, T productNode, int index) {
        Assert.notNull(productNodeGroup, (String)"group");
        Assert.notNull(productNode, (String)"node");
        this.productNodeGroup = productNodeGroup;
        this.productNode = productNode;
        this.index = index;
    }

    public T getProductNode() {
        return this.productNode;
    }

    @Override
    public String getPresentationName() {
        return Bundle.LBL_UndoableProductNodeDeletionName(this.productNode.getName());
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.index < this.productNodeGroup.getNodeCount()) {
            this.productNodeGroup.add(this.index, this.productNode);
        } else {
            this.productNodeGroup.add(this.productNode);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.productNodeGroup.remove(this.productNode);
    }

    @Override
    public void die() {
        this.productNodeGroup = null;
        this.productNode = null;
    }
}

