/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.nodes.NodeExpansionManager;
import org.esa.snap.rcp.nodes.PNGroupBase;
import org.esa.snap.rcp.nodes.PNNode;
import org.esa.snap.rcp.nodes.PNNodeBase;
import org.esa.snap.rcp.nodes.UndoableProductNodeEdit;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

abstract class PNNodeSupport
implements ProductNodeListener {
    static final PNNodeSupport NONE = new PNNodeSupport(){

        public void nodeChanged(ProductNodeEvent event) {
        }

        public void nodeDataChanged(ProductNodeEvent event) {
        }

        public void nodeAdded(ProductNodeEvent event) {
        }

        public void nodeRemoved(ProductNodeEvent event) {
        }
    };

    PNNodeSupport() {
    }

    static UndoRedo getUndoRedo(Node node) {
        return node instanceof UndoRedo.Provider ? ((UndoRedo.Provider)node).getUndoRedo() : null;
    }

    static boolean isDirectChild(Children children, ProductNode productNode) {
        return children != Children.LEAF && children.snapshot().stream().filter(node -> node instanceof PNNode).anyMatch(node -> ((PNNode)((Object)node)).getProductNode() == productNode);
    }

    static Action[] getContextActions(ProductNode productNode) {
        ArrayList actionList = new ArrayList();
        Class<?> type = productNode.getClass();
        do {
            List actions = Utilities.actionsForPath((String)("Context/Product/" + type.getSimpleName()));
            actionList.addAll(actions);
        } while ((type = type.getSuperclass()) != null && ProductNode.class.isAssignableFrom(type));
        return actionList.toArray(new Action[actionList.size()]);
    }

    static <T extends ProductNode> void performUndoableProductNodeEdit(String name, T productNode, UndoableProductNodeEdit.Edit<T> action, UndoableProductNodeEdit.Edit<T> undo) {
        UndoRedo.Manager undoManager;
        action.edit(productNode);
        Product product = productNode.getProduct();
        if (product != null && (undoManager = SnapApp.getDefault().getUndoManager(product)) != null) {
            undoManager.addEdit(new UndoableProductNodeEdit<T>(name, productNode, undo, action));
        }
    }

    public static PNNodeSupport create(PNNodeBase tpnNode, PNGroupBase childFactory) {
        return childFactory != null ? new PNNodeSupportImpl(tpnNode, childFactory) : NONE;
    }

    static class PNNodeSupportImpl
    extends PNNodeSupport {
        private final PNNodeBase node;
        private final PNGroupBase group;

        public PNNodeSupportImpl(PNNodeBase node, PNGroupBase group) {
            this.node = node;
            this.group = group;
        }

        public void nodeChanged(ProductNodeEvent event) {
            if (this.group.shallReactToPropertyChange(event.getPropertyName())) {
                boolean nodeExpanded = NodeExpansionManager.isNodeExpanded((Node)this.node);
                this.group.refresh();
                if (nodeExpanded) {
                    NodeExpansionManager.expandNode((Node)this.node);
                }
            }
            this.delegateProductNodeEvent(l -> l.nodeChanged(event));
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            this.delegateProductNodeEvent(l -> l.nodeDataChanged(event));
        }

        public void nodeAdded(ProductNodeEvent event) {
            this.refreshChildrenAfterAdd(event.getSourceNode());
            this.delegateProductNodeEvent(l -> l.nodeAdded(event));
        }

        public void nodeRemoved(ProductNodeEvent event) {
            this.refreshChildrenAfterRemove(event.getSourceNode());
            this.delegateProductNodeEvent(l -> l.nodeRemoved(event));
        }

        private void refreshChildrenAfterAdd(ProductNode productNode) {
            if (this.group.isDirectChild(productNode)) {
                this.group.refresh();
            }
        }

        private void refreshChildrenAfterRemove(ProductNode productNode) {
            if (this.node.isDirectChild(productNode)) {
                this.group.refresh();
            }
        }

        private void delegateProductNodeEvent(Consumer<ProductNodeListener> action) {
            this.node.getChildren().snapshot().stream().filter(node -> node instanceof ProductNodeListener).map(node -> (ProductNodeListener)node).forEach(action);
        }
    }
}

