/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager;

import com.bc.ceres.glayer.Layer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.esa.snap.ui.product.ProductSceneView;

class LayerTreeTransferHandler
extends TransferHandler {
    private static final DataFlavor layerFlavor = new DataFlavor(LayerContainer.class, "LayerContainer");
    private final ProductSceneView view;
    private final JTree tree;

    LayerTreeTransferHandler(ProductSceneView view, JTree tree) {
        this.view = view;
        this.tree = tree;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
        TreePath treePath = dropLocation.getPath();
        Layer targetLayer = (Layer)treePath.getLastPathComponent();
        int targetIndex = dropLocation.getChildIndex();
        boolean moveAllowed = true;
        if (targetIndex == -1) {
            moveAllowed = targetLayer.isCollectionLayer();
        }
        return support.isDataFlavorSupported(layerFlavor) && support.isDrop() && support.getComponent() == this.tree && moveAllowed;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        LayerContainer transferLayer;
        if (support.getComponent() != this.tree) {
            return false;
        }
        Transferable transferable = support.getTransferable();
        try {
            transferLayer = (LayerContainer)transferable.getTransferData(layerFlavor);
        }
        catch (UnsupportedFlavorException ignore) {
            return false;
        }
        catch (IOException ignore) {
            return false;
        }
        if (!LayerTreeTransferHandler.isValidDrag(support, transferLayer)) {
            return false;
        }
        LayerTreeTransferHandler.removeLayer(transferLayer);
        this.addLayer(transferLayer, support);
        return true;
    }

    @Override
    public int getSourceActions(JComponent component) {
        return component == this.tree ? 2 : 0;
    }

    @Override
    protected Transferable createTransferable(JComponent component) {
        if (component == this.tree) {
            Layer draggedLayer = this.view.getSelectedLayer();
            Layer oldParentLayer = draggedLayer.getParent();
            int oldChildIndex = oldParentLayer.getChildIndex(draggedLayer.getId());
            return new LayerTransferable(draggedLayer, oldParentLayer, oldChildIndex);
        }
        return null;
    }

    private void addLayer(LayerContainer layerContainer, TransferHandler.TransferSupport support) {
        Layer transferLayer = layerContainer.getDraggedLayer();
        JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
        TreePath treePath = dropLocation.getPath();
        Layer targetLayer = (Layer)treePath.getLastPathComponent();
        List targetList = targetLayer.getChildren();
        int targetIndex = dropLocation.getChildIndex();
        if (targetIndex == -1) {
            targetIndex = 0;
        }
        if (targetList.size() <= targetIndex) {
            targetList.add(transferLayer);
        } else {
            targetList.add(targetIndex, transferLayer);
        }
        TreePath newTreePath = treePath.pathByAddingChild(transferLayer);
        this.tree.makeVisible(newTreePath);
        this.tree.scrollPathToVisible(newTreePath);
    }

    private static void removeLayer(LayerContainer layerContainer) {
        Layer oldParentayer = layerContainer.getOldParentLayer();
        int oldIndex = layerContainer.getOldChildIndex();
        oldParentayer.getChildren().remove(oldIndex);
    }

    private static boolean isValidDrag(TransferHandler.TransferSupport support, LayerContainer layerContainer) {
        Object[] path;
        JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
        TreePath treePath = dropLocation.getPath();
        for (Object o : path = treePath.getPath()) {
            Layer layer = (Layer)o;
            if (layer != layerContainer.getDraggedLayer()) continue;
            return false;
        }
        Layer targetLayer = (Layer)treePath.getLastPathComponent();
        int targetIndex = dropLocation.getChildIndex();
        if (targetIndex == -1) {
            return targetLayer.isCollectionLayer();
        }
        return true;
    }

    private static class LayerContainer {
        private final Layer draggedLayer;
        private final Layer oldParentLayer;
        private final int oldChildIndex;

        private LayerContainer(Layer draggedLayer, Layer oldParentLayer, int oldChildIndex) {
            this.draggedLayer = draggedLayer;
            this.oldParentLayer = oldParentLayer;
            this.oldChildIndex = oldChildIndex;
        }

        public Layer getDraggedLayer() {
            return this.draggedLayer;
        }

        public Layer getOldParentLayer() {
            return this.oldParentLayer;
        }

        public int getOldChildIndex() {
            return this.oldChildIndex;
        }
    }

    private static class LayerTransferable
    implements Transferable {
        private LayerContainer layerContainer;

        private LayerTransferable(Layer draggedLayer, Layer oldParentLayer, int oldChildIndex) {
            this.layerContainer = new LayerContainer(draggedLayer, oldParentLayer, oldChildIndex);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{layerFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(layerFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!flavor.equals(layerFlavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.layerContainer;
        }
    }
}

