/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.developer;

import java.awt.BorderLayout;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import org.esa.snap.rcp.developer.Bundle;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ActionContextMonitorTopComponent", persistenceType=2)
public final class ActionContextMonitorTopComponent
extends TopComponent
implements LookupListener {
    private JLabel infoLabel;
    private JTable infoTable;
    private Lookup.Result<Object> result;

    public ActionContextMonitorTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_ActionContextMonitorTopComponentName());
        this.setToolTipText(Bundle.CTL_ActionContextMonitorTopComponentDescription());
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.keep_preferred_size_when_slided_in", Boolean.TRUE);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.infoLabel = new JLabel("");
        this.infoTable = new JTable();
        this.add(this.infoLabel, "North");
        this.add(new JScrollPane(this.infoTable), "Center");
    }

    public void resultChanged(LookupEvent lookupEvent) {
        Collection selectedObjects = this.result.allInstances();
        if (!selectedObjects.isEmpty()) {
            Object[][] data = new Object[selectedObjects.size()][3];
            int i = 0;
            for (Object selectedObject : selectedObjects) {
                data[i][0] = i + 1;
                data[i][1] = selectedObject.getClass().getSimpleName();
                data[i][2] = String.valueOf(selectedObject);
                ++i;
            }
            this.infoLabel.setText(selectedObjects.size() + " objects(s) selected:");
            this.infoTable.setModel(new DefaultTableModel(data, new String[]{"#", "Type", "Name"}));
            this.infoTable.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.infoTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        } else {
            this.infoLabel.setText("No objects selected.");
            this.infoTable.setModel(new DefaultTableModel());
        }
    }

    public void componentOpened() {
        this.result = Utilities.actionsGlobalContext().lookupResult(Object.class);
        this.result.addLookupListener((LookupListener)this);
    }

    public void componentClosed() {
        this.result.removeLookupListener((LookupListener)this);
    }
}

