/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.esa.snap.rcp.about.SnapAboutBox;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;

class AboutPanel
extends JPanel {
    public AboutPanel() {
        this.setLayout(new BorderLayout(8, 8));
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        FileObject configFile = FileUtil.getConfigFile((String)"AboutBox");
        if (configFile != null) {
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add("SNAP", new SnapAboutBox());
            this.addAboutBoxPlugins(tabbedPane, configFile);
            this.add((Component)tabbedPane, "Center");
        } else {
            this.add((Component)new SnapAboutBox(), "Center");
        }
    }

    private void addAboutBoxPlugins(JTabbedPane tabbedPane, FileObject configFile) {
        FileObject[] aboutBoxPanels = configFile.getChildren();
        List orderedAboutBoxPanels = FileUtil.getOrder(Arrays.asList(aboutBoxPanels), (boolean)true);
        for (FileObject aboutBoxFileObject : orderedAboutBoxPanels) {
            Image image;
            String displayName;
            JComponent panel = (JComponent)FileUtil.getConfigObject((String)aboutBoxFileObject.getPath(), JComponent.class);
            if (panel == null || (displayName = (String)aboutBoxFileObject.getAttribute("displayName")) == null || displayName.trim().isEmpty()) continue;
            ImageIcon icon = null;
            String iconPath = (String)aboutBoxFileObject.getAttribute("iconPath");
            if (iconPath != null && !iconPath.trim().isEmpty() && (image = ImageUtilities.loadImage((String)iconPath, (boolean)false)) != null) {
                icon = new ImageIcon(image);
            }
            tabbedPane.addTab(displayName, icon, panel);
        }
    }
}

