/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.netbeans.docwin;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.esa.snap.netbeans.docwin.DocumentWindow;
import org.esa.snap.netbeans.docwin.WindowContainer;
import org.esa.snap.netbeans.docwin.WindowUtilities;
import org.esa.snap.netbeans.docwin.WorkspaceTopComponent;
import org.openide.util.Lookup;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DocumentWindowManager
implements WindowContainer<DocumentWindow> {
    private static DocumentWindowManager defaultInstance;
    private final Map<Listener, Set<Predicate>> listeners = new LinkedHashMap<Listener, Set<Predicate>>();
    private final Set<DocumentWindow> openDocumentWindows = new LinkedHashSet<DocumentWindow>();
    private DocumentWindow selectedDocumentWindow;

    public static DocumentWindowManager getDefault() {
        DocumentWindowManager instance = (DocumentWindowManager)Lookup.getDefault().lookup(DocumentWindowManager.class);
        return instance != null ? instance : DocumentWindowManager.getDefaultInstance();
    }

    protected DocumentWindowManager() {
        this.captureCurrentState();
        WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)new RegistryPropertyChangeDelegate());
    }

    @Override
    public DocumentWindow getSelectedWindow() {
        return this.selectedDocumentWindow;
    }

    @Override
    public List<DocumentWindow> getOpenedWindows() {
        return new ArrayList<DocumentWindow>(this.openDocumentWindows);
    }

    public boolean openWindow(DocumentWindow documentWindow) {
        TopComponent topComponent = documentWindow.getTopComponent();
        WorkspaceTopComponent workspaceTopComponent = WorkspaceTopComponent.findShowingInstance();
        if (workspaceTopComponent != null) {
            workspaceTopComponent.addTopComponent(topComponent);
            return true;
        }
        Mode editor = WindowManager.getDefault().findMode("editor");
        if (editor.dockInto(topComponent)) {
            topComponent.open();
            return true;
        }
        return false;
    }

    public boolean closeWindow(DocumentWindow documentWindow) {
        Optional<WorkspaceTopComponent> anyWorkspace = WindowUtilities.getOpened(WorkspaceTopComponent.class).filter(tc -> tc.getTopComponents().contains(documentWindow.getTopComponent())).findAny();
        if (anyWorkspace.isPresent()) {
            return anyWorkspace.get().removeTopComponent(documentWindow.getTopComponent());
        }
        return this.removeOpenedWindow(documentWindow);
    }

    public void requestSelected(DocumentWindow documentWindow) {
        TopComponent topComponent = documentWindow.getTopComponent();
        List<WorkspaceTopComponent> showingWorkspaces = WorkspaceTopComponent.findShowingInstances();
        for (WorkspaceTopComponent showingWorkspace : showingWorkspaces) {
            if (!showingWorkspace.getTopComponents().contains(topComponent)) continue;
            showingWorkspace.requestActiveTopComponent(topComponent);
            return;
        }
        topComponent.requestActive();
    }

    public final void addListener(Listener listener) {
        this.addListener(Predicate.any(), listener);
    }

    public final <D, V> void addListener(Predicate<D, V> predicate, Listener<D, V> listener) {
        Set<Predicate> predicates = this.listeners.get(listener);
        if (predicates == null) {
            predicates = new HashSet<Predicate>();
            this.listeners.put(listener, predicates);
        }
        predicates.add(predicate);
    }

    public final void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public final <D, V> void removeListener(Predicate<D, V> predicate, Listener<D, V> listener) {
        Set<Predicate> predicates = this.listeners.get(listener);
        if (predicates != null) {
            predicates.remove(predicate);
            if (predicates.isEmpty()) {
                this.listeners.remove(listener);
            }
        }
    }

    public final Listener[] getListeners() {
        return this.listeners.keySet().toArray(new Listener[this.listeners.size()]);
    }

    final Listener[] getListeners(DocumentWindow documentWindow) {
        ArrayList<Listener> listeners = new ArrayList<Listener>();
        block0: for (Map.Entry<Listener, Set<Predicate>> entry : this.listeners.entrySet()) {
            Listener listener = entry.getKey();
            Set<Predicate> predicates = entry.getValue();
            for (Predicate predicate : predicates) {
                if (!this.isPredicateApplicable(predicate, documentWindow) || !predicate.test(documentWindow)) continue;
                listeners.add(listener);
                continue block0;
            }
        }
        return listeners.toArray(new Listener[listeners.size()]);
    }

    private boolean isPredicateApplicable(Predicate predicate, DocumentWindow documentWindow) {
        Object document = documentWindow.getDocument();
        Object view = documentWindow.getView();
        Class actualDocType = document != null ? document.getClass() : Object.class;
        Class actualViewType = view != null ? view.getClass() : Object.class;
        Class requestedDocType = predicate.getDocType();
        Class requestedViewType = predicate.getViewType();
        return requestedDocType.isAssignableFrom(actualDocType) && requestedViewType.isAssignableFrom(actualViewType);
    }

    void addOpenedWindow(DocumentWindow documentWindow) {
        if (this.openDocumentWindows.add(documentWindow)) {
            this.fireWindowEvent(Event.Type.WINDOW_OPENED, documentWindow);
        }
    }

    boolean removeOpenedWindow(DocumentWindow documentWindow) {
        if (this.openDocumentWindows.remove(documentWindow)) {
            boolean isClosed;
            if (this.getSelectedWindow() == documentWindow) {
                this.setSelectedWindow(null);
            }
            if (isClosed = documentWindow.getTopComponent().close()) {
                this.fireWindowEvent(Event.Type.WINDOW_CLOSED, documentWindow);
            }
            return isClosed;
        }
        return false;
    }

    void setSelectedWindow(DocumentWindow newValue) {
        DocumentWindow oldValue = this.selectedDocumentWindow;
        if (oldValue != newValue) {
            this.selectedDocumentWindow = newValue;
            if (oldValue != null) {
                oldValue.componentDeselected();
                this.fireWindowEvent(Event.Type.WINDOW_DESELECTED, oldValue);
            }
            if (newValue != null) {
                newValue.componentSelected();
                this.fireWindowEvent(Event.Type.WINDOW_SELECTED, newValue);
            }
        }
    }

    private void fireWindowEvent(Event.Type eventType, DocumentWindow documentWindow) {
        Listener[] listeners = this.getListeners(documentWindow);
        if (listeners.length > 0) {
            Event event = new Event(eventType, documentWindow);
            block6: for (Listener listener : listeners) {
                switch (eventType) {
                    case WINDOW_OPENED: {
                        listener.windowOpened(event);
                        continue block6;
                    }
                    case WINDOW_CLOSED: {
                        listener.windowClosed(event);
                        continue block6;
                    }
                    case WINDOW_SELECTED: {
                        listener.windowSelected(event);
                        continue block6;
                    }
                    case WINDOW_DESELECTED: {
                        listener.windowDeselected(event);
                    }
                }
            }
        }
    }

    private static DocumentWindowManager getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DocumentWindowManager();
        }
        return defaultInstance;
    }

    private void captureCurrentState() {
        TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
        Set topComponents = registry.getOpened();
        topComponents.stream().filter(topComponent -> topComponent instanceof DocumentWindow).forEach(topComponent -> {
            DocumentWindow documentWindow = (DocumentWindow)topComponent;
            this.openDocumentWindows.add(documentWindow);
            if (registry.getActivated() == topComponent) {
                this.selectedDocumentWindow = documentWindow;
            }
        });
    }

    private class RegistryPropertyChangeDelegate
    implements PropertyChangeListener {
        private RegistryPropertyChangeDelegate() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue;
            if ("activated".equals(evt.getPropertyName())) {
                Object newValue2 = evt.getNewValue();
                if (newValue2 instanceof DocumentWindow) {
                    DocumentWindowManager.this.setSelectedWindow((DocumentWindow)newValue2);
                }
            } else if ("tcOpened".equals(evt.getPropertyName())) {
                Object newValue3 = evt.getNewValue();
                if (newValue3 instanceof DocumentWindow) {
                    DocumentWindowManager.this.addOpenedWindow((DocumentWindow)newValue3);
                }
            } else if ("tcClosed".equals(evt.getPropertyName()) && (newValue = evt.getNewValue()) instanceof DocumentWindow) {
                DocumentWindowManager.this.removeOpenedWindow((DocumentWindow)newValue);
            }
        }
    }

    public static class Starter
    implements Runnable {
        @Override
        public void run() {
            DocumentWindowManager.getDefault();
        }
    }

    public static interface Listener<D, V>
    extends EventListener {
        default public void windowOpened(Event<D, V> e) {
        }

        default public void windowClosed(Event<D, V> e) {
        }

        default public void windowSelected(Event<D, V> e) {
        }

        default public void windowDeselected(Event<D, V> e) {
        }
    }

    public static final class Event<D, V>
    extends EventObject {
        private final DocumentWindow<D, V> documentWindow;
        private final Type type;

        Event(Type type, DocumentWindow<D, V> documentWindow) {
            super(documentWindow);
            this.type = type;
            this.documentWindow = documentWindow;
        }

        public Type getType() {
            return this.type;
        }

        public DocumentWindow<D, V> getWindow() {
            return this.documentWindow;
        }

        @Override
        public String toString() {
            return "Event{type=" + (Object)((Object)this.type) + ", documentWindow=" + this.documentWindow + '}';
        }

        public static enum Type {
            WINDOW_OPENED,
            WINDOW_CLOSED,
            WINDOW_SELECTED,
            WINDOW_DESELECTED;

        }
    }

    public static class DefaultPredicate<D, V>
    implements Predicate<D, V> {
        private static final Predicate<Object, Object> ANY = new DefaultPredicate<Object, Object>(Object.class, Object.class);
        private final Class<D> docType;
        private final Class<V> viewType;

        public DefaultPredicate(Class<D> docType, Class<V> viewType) {
            this.docType = docType;
            this.viewType = viewType;
        }

        @Override
        public Class<D> getDocType() {
            return this.docType;
        }

        @Override
        public Class<V> getViewType() {
            return this.viewType;
        }

        @Override
        public boolean test(DocumentWindow window) {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultPredicate that = (DefaultPredicate)o;
            return this.getDocType().equals(that.getDocType()) && this.getViewType().equals(that.getViewType());
        }

        public int hashCode() {
            int result = this.getDocType().hashCode();
            result = 31 * result + this.getViewType().hashCode();
            return result;
        }
    }

    public static interface Predicate<D, V> {
        public Class<D> getDocType();

        public Class<V> getViewType();

        public boolean test(DocumentWindow var1);

        public static Predicate<Object, Object> any() {
            return DefaultPredicate.ANY;
        }

        public static <D> Predicate<D, Object> doc(Class<D> docType) {
            return new DefaultPredicate<D, Object>(docType, Object.class);
        }

        public static <V> Predicate<Object, V> view(Class<V> viewType) {
            return new DefaultPredicate<Object, V>(Object.class, viewType);
        }

        public static <D, V> Predicate<D, V> docView(Class<D> docType, Class<V> viewType) {
            return new DefaultPredicate<D, V>(docType, viewType);
        }
    }
}

