/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.StyledLayerImpl;
import org.geotools.styling.UserLayer;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledLayerDescriptorImpl
implements StyledLayerDescriptor {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.styling");
    private String name;
    private String title;
    private String abstractStr;
    private List<StyledLayer> layers = new ArrayList<StyledLayer>();

    public Style getDefaultStyle() {
        for (int i = 0; i < this.layers.size(); ++i) {
            StyledLayer layer = this.layers.get(i);
            if (!(layer instanceof UserLayer)) continue;
            UserLayer userLayer = (UserLayer)layer;
            Style[] styles = userLayer.getUserStyles();
            for (int j = 0; j < styles.length; ++j) {
                if (!styles[j].isDefault()) continue;
                return styles[j];
            }
        }
        return null;
    }

    public StyledLayer[] getStyledLayers() {
        return this.layers.toArray(new StyledLayerImpl[this.layers.size()]);
    }

    public void setStyledLayers(StyledLayer[] layers) {
        this.layers.clear();
        for (int i = 0; i < layers.length; ++i) {
            this.addStyledLayer(layers[i]);
        }
        LOGGER.fine("StyleLayerDescriptorImpl added " + this.layers.size() + " styled layers");
    }

    public List<StyledLayer> layers() {
        return this.layers;
    }

    public void addStyledLayer(StyledLayer layer) {
        this.layers.add((StyledLayerImpl)layer);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAbstract() {
        return this.abstractStr;
    }

    public void setAbstract(String abstractStr) {
        this.abstractStr = abstractStr;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((StyledLayerDescriptor)this);
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof StyledLayerDescriptorImpl) {
            StyledLayerDescriptorImpl other = (StyledLayerDescriptorImpl)oth;
            return Utilities.equals((Object)this.abstractStr, (Object)other.abstractStr) && Utilities.equals(this.layers, other.layers) && Utilities.equals((Object)this.name, (Object)other.name) && Utilities.equals((Object)this.title, (Object)other.title);
        }
        return false;
    }
}

