/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FilteringIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringSimpleFeatureCollection
extends DecoratingSimpleFeatureCollection {
    SimpleFeatureCollection delegate;
    Filter filter;

    public FilteringSimpleFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, Filter filter) {
        this(DataUtilities.simple(delegate), filter);
    }

    public FilteringSimpleFeatureCollection(SimpleFeatureCollection delegate, Filter filter) {
        super(delegate);
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public SimpleFeatureIterator features() {
        return new DelegateSimpleFeatureIterator((FeatureCollection<SimpleFeatureType, SimpleFeature>)this, this.iterator());
    }

    public void close(SimpleFeatureIterator close) {
        close.close();
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        return new FilteringIterator<SimpleFeature>(this.delegate.iterator(), this.filter);
    }

    @Override
    public void close(Iterator<SimpleFeature> close) {
        FilteringIterator filtering = (FilteringIterator)close;
        this.delegate.close(filtering.getDelegate());
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int count = 0;
        Iterator<SimpleFeature> i = this.iterator();
        try {
            while (i.hasNext()) {
                ++count;
                i.next();
            }
            int n = count;
            return n;
        }
        finally {
            this.close(i);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray(Object[] a) {
        ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>();
        Iterator<SimpleFeature> i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
            Object[] objectArray = list.toArray(a);
            return objectArray;
        }
        finally {
            this.close(i);
        }
    }

    @Override
    public boolean add(SimpleFeature o) {
        if (!this.filter.evaluate((Object)o)) {
            return false;
        }
        return this.delegate.add((Feature)o);
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o) && this.filter.evaluate(o);
    }

    @Override
    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            changed |= this.add((SimpleFeature)i.next());
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema(), (FeatureIterator<SimpleFeature>)this.features());
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return ReferencedEnvelope.reference((Envelope)DataUtilities.bounds((FeatureCollection<? extends FeatureType, ? extends Feature>)this));
    }
}

