/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.feature.collection.RandomFeatureAccess;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.util.ProgressListener;

public class MemoryFeatureCollection
extends AbstractFeatureCollection
implements RandomFeatureAccess {
    TreeMap contents = new TreeMap();

    public MemoryFeatureCollection(SimpleFeatureType schema) {
        super(schema);
    }

    public boolean add(SimpleFeature o) {
        SimpleFeature feature = o;
        this.contents.put(feature.getID(), feature);
        return true;
    }

    public int size() {
        return this.contents.size();
    }

    public Iterator openIterator() {
        return new MemoryIterator(this.contents.values().iterator());
    }

    public void closeIterator(Iterator close) {
        if (close == null) {
            return;
        }
        MemoryIterator it = (MemoryIterator)close;
        it.close();
    }

    public SimpleFeature getFeatureMember(String id) throws NoSuchElementException {
        if (this.contents.containsKey(id)) {
            return (SimpleFeature)this.contents.get(id);
        }
        throw new NoSuchElementException(id);
    }

    public SimpleFeature removeFeatureMember(String id) {
        if (this.contents.containsKey(id)) {
            SimpleFeature old = (SimpleFeature)this.contents.get(id);
            this.contents.remove(id);
            return old;
        }
        return null;
    }

    public ReferencedEnvelope getBounds() {
        BoundsVisitor bounds = new BoundsVisitor();
        this.accepts(bounds, (ProgressListener)new NullProgressListener());
        return bounds.getBounds();
    }

    class MemoryIterator
    implements Iterator {
        Iterator it;

        MemoryIterator(Iterator iterator) {
            this.it = iterator;
        }

        public void close() {
            this.it = null;
        }

        public boolean hasNext() {
            if (this.it == null) {
                throw new IllegalStateException();
            }
            return this.it.hasNext();
        }

        public Object next() {
            if (this.it == null) {
                throw new IllegalStateException();
            }
            return this.it.next();
        }

        public void remove() {
            this.it.remove();
        }
    }
}

