/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DelegatingFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxFeatureReader<T extends FeatureType, F extends Feature>
implements DelegatingFeatureReader<T, F> {
    protected final FeatureReader<T, F> featureReader;
    protected final int maxFeatures;
    protected int counter = 0;

    public MaxFeatureReader(FeatureReader<T, F> featureReader, int maxFeatures) {
        this.featureReader = featureReader;
        this.maxFeatures = maxFeatures;
    }

    @Override
    public FeatureReader<T, F> getDelegate() {
        return this.featureReader;
    }

    public F next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.hasNext()) {
            ++this.counter;
            return (F)this.featureReader.next();
        }
        throw new NoSuchElementException("No such Feature exists");
    }

    public void close() throws IOException {
        this.featureReader.close();
    }

    public T getFeatureType() {
        return (T)this.featureReader.getFeatureType();
    }

    public boolean hasNext() throws IOException {
        return this.featureReader.hasNext() && this.counter < this.maxFeatures;
    }
}

