/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.util;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;

class MissingTilesPropertyFileGenerator {
    private MissingTilesPropertyFileGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Properties properties = new Properties();
        File directory = new File(args[0]);
        Product product = ProductIO.readProduct((File)new File(args[1]));
        Band land_water = product.getBandAt(0);
        for (int x = -180; x < 180; ++x) {
            for (int y = 89; y >= -90; --y) {
                String tileFileName = MissingTilesPropertyFileGenerator.getTileFileName(x, y);
                String propertyKey = tileFileName.substring(0, tileFileName.indexOf(46));
                if (y >= 60 || y <= -60) {
                    properties.setProperty(propertyKey, "127");
                    continue;
                }
                if (new File(directory, tileFileName).exists()) continue;
                System.out.printf("Not existing: %s%n", tileFileName);
                int landWater = MissingTilesPropertyFileGenerator.getLandWaterValue(land_water, x, y);
                properties.setProperty(propertyKey, String.valueOf(landWater));
            }
        }
        properties.setProperty("e034n18", "0");
        properties.setProperty("e019n09", "0");
        properties.setProperty("e026n00", "0");
        try (FileWriter writer = new FileWriter(new File(directory, "MissingTiles.properties"));){
            properties.store(writer, null);
        }
    }

    private static int getLandWaterValue(Band landWaterBand, int x, int y) {
        PixelPos pixelPos = landWaterBand.getGeoCoding().getPixelPos(new GeoPos((double)y, (double)x), null);
        Raster raster = landWaterBand.getSourceImage().getData(new Rectangle((int)pixelPos.getX(), (int)pixelPos.getY(), 1, 1));
        int sample = raster.getSample((int)pixelPos.getX(), (int)pixelPos.getY(), 0);
        return sample == 17 ? 1 : 0;
    }

    static String getTileFileName(double lon, double lat) {
        boolean geoPosIsWest = lon < 0.0;
        boolean geoPosIsSouth = lat < 0.0;
        String eastOrWest = geoPosIsWest ? "w" : "e";
        String northOrSouth = geoPosIsSouth ? "s" : "n";
        return String.format("%s%03d%s%02d.img", eastOrWest, (int)Math.abs(Math.floor(lon)), northOrSouth, (int)Math.abs(Math.floor(lat)));
    }
}

