/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.operator;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.text.MessageFormat;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.watermask.operator.WatermaskClassifier;

@OperatorMetadata(alias="LandWaterMask", version="1.3", internal=false, authors="Thomas Storm", copyright="(c) 2011-2014 by Brockmann Consult", description="Operator creating a target product with a single band containing a land/water-mask.", category="Raster/Masks")
public class WatermaskOp
extends Operator {
    @SourceProduct(alias="source", description="The Product the land/water-mask shall be computed for.", label="Name")
    private Product sourceProduct;
    @Parameter(description="Specifies on which resolution the water mask shall be based.", unit="m/pixel", label="Resolution", defaultValue="50", valueSet={"50", "150", "1000"})
    private int resolution;
    @Parameter(description="Specifies the factor between the resolution of the source product and the watermask in x direction. A value of '1' means no subsampling at all.", label="Subsampling factor x", defaultValue="1", notNull=true)
    private int subSamplingFactorX;
    @Parameter(description="Specifies the factor between the resolution of the source product and the watermask iny direction. A value of '1' means no subsampling at all.", label="Subsampling factor y", defaultValue="1", notNull=true)
    private int subSamplingFactorY;
    @TargetProduct
    private Product targetProduct;
    private WatermaskClassifier classifier;

    public void initialize() throws OperatorException {
        this.validateParameter();
        this.validateSourceProduct();
        this.initTargetProduct();
        try {
            this.classifier = new WatermaskClassifier(this.resolution, this.subSamplingFactorX, this.subSamplingFactorY);
        }
        catch (IOException e) {
            throw new OperatorException("Error creating class WatermaskClassifier.", (Throwable)e);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle rectangle = targetTile.getRectangle();
        try {
            GeoCoding geoCoding = this.sourceProduct.getSceneGeoCoding();
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    byte waterFraction = this.classifier.getWaterMaskFraction(geoCoding, x, y);
                    targetTile.setSample(x, y, (int)waterFraction);
                }
            }
        }
        catch (Exception e) {
            throw new OperatorException("Error computing tile '" + targetTile.getRectangle().toString() + "'.", (Throwable)e);
        }
    }

    private void validateParameter() {
        if (this.resolution != 50 && this.resolution != 150 && this.resolution != 1000) {
            throw new OperatorException(String.format("Resolution needs to be either %d, %d or, %d.", 50, 150, 1000));
        }
        if (this.subSamplingFactorX < 1) {
            String msgPattern = "Subsampling factor needs to be greater than or equal to 1; was: ''{0}''.";
            String message = MessageFormat.format(msgPattern, this.subSamplingFactorX);
            throw new OperatorException(message);
        }
    }

    private void validateSourceProduct() {
        this.ensureSingleRasterSize(new Product[]{this.sourceProduct});
        GeoCoding geoCoding = this.sourceProduct.getSceneGeoCoding();
        if (geoCoding == null) {
            throw new OperatorException("The source product must be geo-coded.");
        }
        if (!geoCoding.canGetGeoPos()) {
            throw new OperatorException("The geo-coding of the source product can not be used.\nIt does not provide the geo-position for a pixel position.");
        }
    }

    private void initTargetProduct() {
        this.targetProduct = new Product("LW-Mask", "land_water_mask", this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        Band band = this.targetProduct.addBand("land_water_fraction", 10);
        band.setNoDataValue(127.0);
        band.setNoDataValueUsed(true);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(WatermaskOp.class);
        }
    }
}

