/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.operator;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.SourcelessOpImage;
import org.esa.snap.core.image.ImageHeader;
import org.esa.snap.core.util.ImageUtils;
import org.esa.snap.core.util.jai.SingleBandedSampleModel;

public class PNGSourceImage
extends SourcelessOpImage {
    private final ZipFile zipFile;

    static PNGSourceImage create(Properties properties, File zipFile) throws IOException {
        ImageHeader imageHeader = ImageHeader.load((Properties)properties, null);
        return new PNGSourceImage(imageHeader, zipFile);
    }

    private PNGSourceImage(ImageHeader imageHeader, File zipFile) throws IOException {
        super(imageHeader.getImageLayout(), null, ImageUtils.createSingleBandedSampleModel((int)0, (int)imageHeader.getImageLayout().getSampleModel(null).getWidth(), (int)imageHeader.getImageLayout().getSampleModel(null).getHeight()), imageHeader.getImageLayout().getMinX(null), imageHeader.getImageLayout().getMinY(null), imageHeader.getImageLayout().getWidth(null), imageHeader.getImageLayout().getHeight(null));
        this.zipFile = new ZipFile(zipFile);
        this.setTileCache(JAI.createTileCache((long)0x3200000L));
    }

    public Raster computeTile(int tileX, int tileY) {
        Raster raster;
        try {
            raster = this.computeRawRaster(tileX, tileY);
        }
        catch (IOException e) {
            throw new RuntimeException(MessageFormat.format("Failed to read image tile ''{0} | {1}''.", tileX, tileY), e);
        }
        return raster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Raster computeRawRaster(int tileX, int tileY) throws IOException {
        String fileName = this.getFileName(tileX, tileY);
        WritableRaster targetRaster = this.createWritableRaster(tileX, tileY);
        ZipEntry zipEntry = this.zipFile.getEntry(fileName);
        try (InputStream inputStream = null;){
            inputStream = this.zipFile.getInputStream(zipEntry);
            BufferedImage image = ImageIO.read(inputStream);
            Raster imageData = image.getData();
            for (int x = 0; x < imageData.getWidth(); ++x) {
                int xPos = this.tileXToX(tileX) + x;
                for (int y = 0; y < imageData.getHeight(); ++y) {
                    byte sample = (byte)imageData.getSample(x, y, 0);
                    sample = (byte)Math.abs(sample - 1);
                    int yPos = this.tileYToY(tileY) + y;
                    targetRaster.setSample(xPos, yPos, 0, sample);
                }
            }
        }
        return targetRaster;
    }

    private WritableRaster createWritableRaster(int tileX, int tileY) {
        Point location = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        SingleBandedSampleModel sampleModel = new SingleBandedSampleModel(0, this.getTileWidth(), this.getTileHeight());
        return this.createWritableRaster((SampleModel)sampleModel, location);
    }

    private String getFileName(int tileX, int tileY) {
        return String.format("%d-%d.png", tileX, tileY);
    }
}

