/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.xLink;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeGroup;
import org.geotools.xml.schema.AttributeValue;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.impl.AttributeValueGT;
import org.geotools.xml.schema.impl.FacetGT;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XLinkSchema
implements Schema {
    private static Schema instance = new XLinkSchema();
    private static final Attribute[] attributes = XLinkSchema.loadAttributes();
    private static final AttributeGroup[] attributeGroups = XLinkSchema.loadAttributeGroups();
    public static final URI NAMESPACE = XLinkSchema.makeURI("http://www.w3.org/1999/xlink");

    public static Schema getInstance() {
        return instance;
    }

    private static Attribute[] loadAttributes() {
        Attribute[] r = new Attribute[]{Href.getInstance(), Role.getInstance(), Arcrole.getInstance(), Title.getInstance(), Show.getInstance(), Actuate.getInstance(), Label.getInstance(), From.getInstance(), To.getInstance()};
        return r;
    }

    private static AttributeGroup[] loadAttributeGroups() {
        AttributeGroup[] r = new AttributeGroup[]{SimpleLink.getInstance(), ExtendedLink.getInstance(), LocatorLink.getInstance(), ArcLink.getInstance(), ResourceLink.getInstance(), TitleLink.getInstance(), EmptyLink.getInstance()};
        return r;
    }

    public AttributeGroup[] getAttributeGroups() {
        return attributeGroups;
    }

    public Attribute[] getAttributes() {
        return attributes;
    }

    public int getBlockDefault() {
        return 0;
    }

    public ComplexType[] getComplexTypes() {
        return new ComplexType[0];
    }

    public Element[] getElements() {
        return new Element[0];
    }

    public int getFinalDefault() {
        return 0;
    }

    public Group[] getGroups() {
        return new Group[0];
    }

    public String getId() {
        return null;
    }

    public Schema[] getImports() {
        return new Schema[0];
    }

    public SimpleType[] getSimpleTypes() {
        return new SimpleType[0];
    }

    public URI getTargetNamespace() {
        return NAMESPACE;
    }

    public URI getURI() {
        return NAMESPACE;
    }

    public String getVersion() {
        return "2.1.2";
    }

    public boolean includesURI(URI uri) {
        return true;
    }

    private static URI makeURI(String s) {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String getPrefix() {
        return "xLink";
    }

    public boolean isAttributeFormDefault() {
        return false;
    }

    public boolean isElementFormDefault() {
        return false;
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public static class EmptyLink
    extends XLinkAttributeGroup {
        private static AttributeGroup instance1;
        static final Attribute[] attributes1;

        public Attribute[] getAttributes() {
            return attributes1;
        }

        public String getName() {
            return "emptyLink";
        }

        public static AttributeGroup getInstance() {
            if (instance1 == null) {
                instance1 = new EmptyLink();
            }
            return instance1;
        }

        static {
            attributes1 = new Attribute[]{new Type("empty")};
        }
    }

    public static class TitleLink
    extends XLinkAttributeGroup {
        private static AttributeGroup instance1;
        static final Attribute[] attributes1;

        public Attribute[] getAttributes() {
            return attributes1;
        }

        public String getName() {
            return "titleLink";
        }

        public static AttributeGroup getInstance() {
            if (instance1 == null) {
                instance1 = new TitleLink();
            }
            return instance1;
        }

        static {
            attributes1 = new Attribute[]{new Type("title")};
        }
    }

    public static class ResourceLink
    extends XLinkAttributeGroup {
        private static AttributeGroup instance1;
        private static final Attribute[] attributes1;

        public Attribute[] getAttributes() {
            return attributes1;
        }

        public String getName() {
            return "resourceLink";
        }

        public static AttributeGroup getInstance() {
            if (instance1 == null) {
                instance1 = new ResourceLink();
            }
            return instance1;
        }

        static {
            attributes1 = new Attribute[]{new Type("resource"), Role.instance1, Title.instance1, Label.instance1};
        }
    }

    public static class ArcLink
    extends XLinkAttributeGroup {
        private static AttributeGroup instance1;
        private static final Attribute[] attributes1;

        public Attribute[] getAttributes() {
            return attributes1;
        }

        public String getName() {
            return "arcLink";
        }

        public static AttributeGroup getInstance() {
            if (instance1 == null) {
                instance1 = new ArcLink();
            }
            return instance1;
        }

        static {
            attributes1 = new Attribute[]{new Type("arc"), Arcrole.instance1, Title.instance1, Show.instance1, Actuate.instance1, From.instance1, To.instance1};
        }
    }

    public static class LocatorLink
    extends XLinkAttributeGroup {
        private static AttributeGroup instance1;
        private static final Attribute[] attributes1;

        public Attribute[] getAttributes() {
            return attributes1;
        }

        public String getName() {
            return "locatorLink";
        }

        public static AttributeGroup getInstance() {
            if (instance1 == null) {
                instance1 = new LocatorLink();
            }
            return instance1;
        }

        static {
            attributes1 = new Attribute[]{new Type("extended"), new Href(2), Role.instance1, Title.instance1, Label.instance1};
        }
    }

    public static class ExtendedLink
    extends XLinkAttributeGroup {
        private static AttributeGroup instance1;
        private static final Attribute[] attributes1;

        public Attribute[] getAttributes() {
            return attributes1;
        }

        public String getName() {
            return "extendedLink";
        }

        public static AttributeGroup getInstance() {
            if (instance1 == null) {
                instance1 = new ExtendedLink();
            }
            return instance1;
        }

        static {
            attributes1 = new Attribute[]{Role.instance1, Title.instance1};
        }
    }

    public static class SimpleLink
    extends XLinkAttributeGroup {
        private static AttributeGroup instance1;
        private static final Attribute[] attributes1;

        public Attribute[] getAttributes() {
            return attributes1;
        }

        public String getName() {
            return "simpleLink";
        }

        public static AttributeGroup getInstance() {
            if (instance1 == null) {
                instance1 = new SimpleLink();
            }
            return instance1;
        }

        static {
            attributes1 = new Attribute[]{Href.instance1, Role.instance1, Arcrole.instance1, Title.instance1, Show.instance1, Actuate.instance1};
        }
    }

    protected static abstract class XLinkAttributeGroup
    implements AttributeGroup {
        protected XLinkAttributeGroup() {
        }

        public URI getNamespace() {
            return NAMESPACE;
        }

        public String getAnyAttributeNameSpace() {
            return null;
        }

        public String getId() {
            return null;
        }
    }

    private static class Type
    extends XLinkAttribute {
        private final String fixed;

        public Type(String fixed) {
            this.fixed = fixed;
        }

        public String getFixed() {
            return this.fixed;
        }

        public String getName() {
            return "type";
        }

        public int getUse() {
            return 2;
        }

        public SimpleType getSimpleType() {
            return XSISimpleTypes.String.getInstance();
        }
    }

    public static class To
    extends XLinkAttribute {
        static Attribute instance1;

        public static Attribute getInstance() {
            if (instance1 == null) {
                instance1 = new To();
            }
            return instance1;
        }

        public String getFixed() {
            return null;
        }

        public String getName() {
            return "to";
        }

        public int getUse() {
            return 0;
        }

        public SimpleType getSimpleType() {
            return XSISimpleTypes.String.getInstance();
        }
    }

    public static class From
    extends XLinkAttribute {
        static Attribute instance1;

        public static Attribute getInstance() {
            if (instance1 == null) {
                instance1 = new From();
            }
            return instance1;
        }

        public String getFixed() {
            return null;
        }

        public String getName() {
            return "from";
        }

        public int getUse() {
            return 0;
        }

        public SimpleType getSimpleType() {
            return XSISimpleTypes.String.getInstance();
        }
    }

    public static class Label
    extends XLinkAttribute {
        static Attribute instance1;

        public static Attribute getInstance() {
            return instance1;
        }

        public String getFixed() {
            return null;
        }

        public String getName() {
            return "label";
        }

        public int getUse() {
            return 0;
        }

        public SimpleType getSimpleType() {
            return XSISimpleTypes.String.getInstance();
        }
    }

    public static class Actuate
    extends XLinkAttribute {
        static Attribute instance1;
        private static SimpleType simpleType;

        public static Attribute getInstance() {
            if (instance1 == null) {
                instance1 = new Actuate();
            }
            return instance1;
        }

        public String getFixed() {
            return null;
        }

        public String getName() {
            return "actuate";
        }

        public int getUse() {
            return 0;
        }

        public SimpleType getSimpleType() {
            return simpleType;
        }

        static {
            simpleType = new ActuateSimpleType();
        }
    }

    public static class Show
    extends XLinkAttribute {
        static Attribute instance1;
        private static SimpleType simpleType;

        public static Attribute getInstance() {
            return instance1;
        }

        public String getFixed() {
            return null;
        }

        public String getName() {
            return "show";
        }

        public int getUse() {
            return 0;
        }

        public SimpleType getSimpleType() {
            return simpleType;
        }

        static {
            simpleType = new ShowSimpleType();
        }
    }

    public static class Title
    extends XLinkAttribute {
        static Attribute instance1;

        public static Attribute getInstance() {
            if (instance1 == null) {
                instance1 = new Title();
            }
            return instance1;
        }

        public String getFixed() {
            return null;
        }

        public String getName() {
            return "title";
        }

        public int getUse() {
            return 0;
        }

        public SimpleType getSimpleType() {
            return XSISimpleTypes.String.getInstance();
        }
    }

    public static class Arcrole
    extends XLinkAttribute {
        static Attribute instance1;

        public static Attribute getInstance() {
            if (instance1 == null) {
                instance1 = new Arcrole();
            }
            return instance1;
        }

        public String getFixed() {
            return null;
        }

        public String getName() {
            return "arcrole";
        }

        public int getUse() {
            return 0;
        }

        public SimpleType getSimpleType() {
            return XSISimpleTypes.AnyURI.getInstance();
        }
    }

    public static class Role
    extends XLinkAttribute {
        static Attribute instance1 = new Role();

        public static Attribute getInstance() {
            return instance1;
        }

        public String getFixed() {
            return null;
        }

        public String getName() {
            return "role";
        }

        public int getUse() {
            return 0;
        }

        public SimpleType getSimpleType() {
            return XSISimpleTypes.AnyURI.getInstance();
        }
    }

    public static class Href
    extends XLinkAttribute {
        static Attribute instance1;
        private int use = 0;

        public Href(int use) {
            this.use = use;
        }

        public Href() {
            this.use = 0;
        }

        public static Attribute getInstance() {
            if (instance1 == null) {
                instance1 = new Href();
            }
            return instance1;
        }

        public String getFixed() {
            return null;
        }

        public String getName() {
            return "href";
        }

        public int getUse() {
            return this.use;
        }

        public SimpleType getSimpleType() {
            return XSISimpleTypes.AnyURI.getInstance();
        }
    }

    protected static abstract class XLinkAttribute
    implements Attribute {
        protected XLinkAttribute() {
        }

        public URI getNamespace() {
            return NAMESPACE;
        }

        public String getDefault() {
            return null;
        }

        public boolean isForm() {
            return false;
        }

        public String getId() {
            return null;
        }
    }

    private static class ShowSimpleType
    implements SimpleType {
        private static List lookUpTable = ShowSimpleType.loadTable();

        private ShowSimpleType() {
        }

        public AttributeValue toAttribute(Attribute attribute, Object value, Map hints) {
            if (this.canCreateAttributes(attribute, value, hints)) {
                return new AttributeValueGT(attribute, (String)value);
            }
            return null;
        }

        public Element findChildElement(String name) {
            return null;
        }

        public boolean canCreateAttributes(Attribute attribute, Object value, Map hints) {
            return attribute.getName() != null && attribute.getName().equals(Actuate.getInstance().getName()) && lookUpTable.contains(value);
        }

        public Class getInstanceType() {
            return String.class;
        }

        public org.geotools.xml.schema.Type getParent() {
            return null;
        }

        public URI getNamespace() {
            return NAMESPACE;
        }

        public int getFinal() {
            return 0;
        }

        public String getId() {
            return null;
        }

        public String getName() {
            return null;
        }

        private static List loadTable() {
            lookUpTable = new LinkedList();
            lookUpTable.add("new");
            lookUpTable.add("replace");
            lookUpTable.add("embed");
            lookUpTable.add("other");
            lookUpTable.add("none");
            return lookUpTable;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 1 || value[0] == null) {
                return null;
            }
            if (value[0].getValue() instanceof String) {
                if (lookUpTable.contains(value[0].getValue())) {
                    return value[0].getValue();
                }
                throw new SAXException("The value speficified was not one of the expected values.");
            }
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) {
        }

        public int getChildType() {
            return 4;
        }

        public SimpleType[] getParents() {
            return new SimpleType[]{XSISimpleTypes.String.getInstance()};
        }

        public Facet[] getFacets() {
            return new Facet[]{new FacetGT(1, "new"), new FacetGT(1, "replace"), new FacetGT(1, "embed"), new FacetGT(1, "other"), new FacetGT(1, "none")};
        }
    }

    private static class ActuateSimpleType
    implements SimpleType {
        private static List lookUpTable = ActuateSimpleType.loadTable();

        private ActuateSimpleType() {
        }

        public Element findChildElement(String name) {
            return null;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) {
        }

        public Class getInstanceType() {
            return String.class;
        }

        public org.geotools.xml.schema.Type getParent() {
            return null;
        }

        public URI getNamespace() {
            return NAMESPACE;
        }

        public int getFinal() {
            return 0;
        }

        public String getId() {
            return null;
        }

        public String getName() {
            return null;
        }

        private static List loadTable() {
            lookUpTable = new LinkedList();
            lookUpTable.add("onLoad");
            lookUpTable.add("onRequest");
            lookUpTable.add("other");
            lookUpTable.add("none");
            return lookUpTable;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 1 || value[0] == null) {
                return null;
            }
            if (value[0].getValue() instanceof String) {
                if (lookUpTable.contains(value[0].getValue())) {
                    return value[0].getValue();
                }
                throw new SAXException("The value speficified was not one of the expected values.");
            }
            return null;
        }

        public AttributeValue toAttribute(Attribute attribute, Object value, Map hints) {
            if (this.canCreateAttributes(attribute, value, hints)) {
                return new AttributeValueGT(attribute, (String)value);
            }
            return null;
        }

        public boolean canCreateAttributes(Attribute attribute, Object value, Map hints) {
            return attribute.getName() != null && attribute.getName().equals(Actuate.getInstance().getName()) && lookUpTable.contains(value);
        }

        public int getChildType() {
            return 4;
        }

        public SimpleType[] getParents() {
            return new SimpleType[]{XSISimpleTypes.String.getInstance()};
        }

        public Facet[] getFacets() {
            return new Facet[]{new FacetGT(1, "onLoad"), new FacetGT(1, "onRequest"), new FacetGT(1, "other"), new FacetGT(1, "none")};
        }
    }
}

