/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.worldmap;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelSource;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.esa.snap.core.image.TiledFileMultiLevelSource;
import org.esa.snap.core.layer.WorldMapLayerType;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.runtime.Config;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.DefaultGeographicCRS;

@LayerTypeMetadata(name="GlobCoverLayerType")
public class GlobCoverLayerType
extends WorldMapLayerType {
    private static final String WORLD_IMAGE_DIR_PROPERTY_NAME = "snap.worldImageDir";
    private static final String WORLD_MAP_LAYER_NAME = "World Map (ESA GlobCover)";
    private static final String WORLD_MAP_LABEL = "ESA GlobCover";
    private volatile MultiLevelSource multiLevelSource;

    public String getLabel() {
        return WORLD_MAP_LABEL;
    }

    public boolean isValidFor(LayerContext ctx) {
        if (ctx.getCoordinateReferenceSystem() instanceof AbstractIdentifiedObject) {
            AbstractIdentifiedObject crs = (AbstractIdentifiedObject)ctx.getCoordinateReferenceSystem();
            return DefaultGeographicCRS.WGS84.equals(crs, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Layer createLayer(LayerContext ctx, PropertySet configuration) {
        Property[] propertyArray;
        if (this.multiLevelSource == null) {
            propertyArray = this;
            // MONITORENTER : this
            if (this.multiLevelSource == null) {
                this.multiLevelSource = GlobCoverLayerType.createMultiLevelSource();
            }
            // MONITOREXIT : propertyArray
        }
        propertyArray = super.createLayerConfig(ctx).getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                configuration.setValue("multiLevelSource", (Object)this.multiLevelSource);
                ImageLayer layer = new ImageLayer((ImageLayer.Type)this, this.multiLevelSource, configuration);
                layer.setName(WORLD_MAP_LAYER_NAME);
                layer.setVisible(true);
                return layer;
            }
            Property model = propertyArray[n2];
            if (configuration.getProperty(model.getDescriptor().getName()) == null) {
                configuration.addProperty(model);
            }
            ++n2;
        }
    }

    private static MultiLevelSource createMultiLevelSource() {
        TiledFileMultiLevelSource multiLevelSource;
        String dirString = Config.instance().preferences().get(WORLD_IMAGE_DIR_PROPERTY_NAME, null);
        Path dirPath = GlobCoverLayerType.getDirPath(dirString);
        if (dirPath == null) {
            throw new IllegalStateException("World image directory not found.");
        }
        try {
            multiLevelSource = TiledFileMultiLevelSource.create((Path)dirPath);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return multiLevelSource;
    }

    private static Path getDirPath(String dirString) {
        Path dirPath = dirString == null || dirString.isEmpty() ? GlobCoverLayerType.getDirPathFromModule() : Paths.get(dirString, new String[0]);
        return dirPath;
    }

    private static Path getDirPathFromModule() {
        try {
            return FileUtils.getPathFromURI((URI)GlobCoverLayerType.class.getResource("image.properties").toURI()).getParent();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

