/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.csv.dataio.writer;

import java.io.IOException;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.csv.dataio.writer.CsvWriter;
import org.esa.snap.csv.dataio.writer.OutputFormatStrategy;
import org.esa.snap.csv.dataio.writer.WriteStrategy;

class PixelCsvWriter
implements CsvWriter {
    private WriteStrategy targetType;
    private final OutputFormatStrategy targetFormat;
    private Product inputProduct;
    private PixelPos[] pixelPositions;

    PixelCsvWriter(WriteStrategy writer, OutputFormatStrategy targetFormat) {
        this.targetType = writer;
        this.targetFormat = targetFormat;
    }

    @Override
    public void writeCsv(Object ... input) throws IOException {
        this.validate(input);
        this.extract(input);
        StringBuilder stringBuilder = new StringBuilder();
        this.targetType.writeCsv(stringBuilder.toString());
    }

    @Override
    public boolean isValidInput(Object ... input) {
        return input != null && input.length == 2 && input[0] instanceof Product && input[1] instanceof PixelPos[];
    }

    private void validate(Object[] input) {
        if (!this.isValidInput(input)) {
            StringBuilder message = new StringBuilder("Illegal input for writing pixels as CSV file: '");
            for (int i = 0; i < input.length; ++i) {
                Object o = input[i];
                message.append(o.toString());
                if (i != input.length - 1) continue;
                message.append(", ");
            }
            message.append("'");
            throw new IllegalArgumentException(message.toString());
        }
    }

    private void extract(Object[] input) {
        this.inputProduct = (Product)input[0];
        this.pixelPositions = (PixelPos[])input[1];
    }
}

