/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.csv.dataio.reader;

import java.io.File;
import java.util.Locale;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.csv.dataio.CsvFile;
import org.esa.snap.csv.dataio.CsvSourceParser;
import org.esa.snap.csv.dataio.reader.CsvProductReader;

public class CsvProductReaderPlugIn
implements ProductReaderPlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecodeQualification getDecodeQualification(Object input) {
        File file = new File(input.toString());
        if (!this.isFileExtensionValid(file)) {
            return DecodeQualification.UNABLE;
        }
        try (CsvSourceParser csvFile = null;){
            csvFile = CsvFile.createCsvSourceParser(input.toString());
            csvFile.parseMetadata();
            csvFile.checkReadingFirstRecord();
        }
        return DecodeQualification.SUITABLE;
    }

    private boolean isFileExtensionValid(File file) {
        String fileExtension = FileUtils.getExtension((File)file);
        if (fileExtension != null) {
            return StringUtils.contains((String[])this.getDefaultFileExtensions(), (String)fileExtension.toLowerCase());
        }
        return false;
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    public ProductReader createReaderInstance() {
        return new CsvProductReader(this);
    }

    public String[] getFormatNames() {
        return new String[]{"CSV"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".csv", ".txt"};
    }

    public String getDescription(Locale locale) {
        return "CSV products";
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

