/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.netbeans.tile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.esa.snap.netbeans.tile.Tileable;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class TileAction
extends AbstractAction
implements ContextAwareAction,
LookupListener,
PropertyChangeListener,
Presenter.Menu {
    private Lookup.Result<Tileable> tileableResult;
    private final Tileable defaultTileable = Tileable.getDefault();

    protected TileAction(Lookup actionContext) {
        this.tileableResult = actionContext.lookupResult(Tileable.class);
        this.tileableResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.tileableResult));
        TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
        registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)registry));
        this.updateState();
    }

    public void resultChanged(LookupEvent ev) {
        this.updateState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean windowCountChanged;
        String propertyName = evt.getPropertyName();
        boolean bl = windowCountChanged = "tcClosed".equals(propertyName) || "tcOpened".equals(propertyName);
        if (windowCountChanged) {
            this.updateState();
        }
    }

    protected Tileable getTileable() {
        Collection tileables = this.tileableResult.allInstances();
        if (!tileables.isEmpty()) {
            return (Tileable)tileables.iterator().next();
        }
        return this.defaultTileable;
    }

    private void updateState() {
        this.setEnabled(this.getTileable().canTile());
    }

    public JMenuItem getMenuPresenter() {
        JMenuItem jMenuItem = new JMenuItem(this);
        jMenuItem.setIcon(null);
        return jMenuItem;
    }
}

