/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.preferences.layer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.esa.snap.core.layer.WorldMapLayerType;
import org.esa.snap.rcp.preferences.DefaultConfigController;
import org.esa.snap.rcp.preferences.Preference;
import org.openide.util.HelpCtx;

public final class WorldMapLayerController
extends DefaultConfigController {
    public static final String PROPERTY_KEY_WORLDMAP_TYPE = "worldmap.type";

    @Override
    protected PropertySet createPropertySet() {
        return this.createPropertySet(new WorldMapBean());
    }

    @Override
    protected JPanel createPanel(BindingContext context) {
        ArrayList<WorldMapLayerType> worldMapLayerTypes = new ArrayList<WorldMapLayerType>();
        for (LayerType layerType : LayerTypeRegistry.getLayerTypes()) {
            if (!(layerType instanceof WorldMapLayerType)) continue;
            WorldMapLayerType worldMapLayerType = (WorldMapLayerType)layerType;
            worldMapLayerTypes.add(worldMapLayerType);
        }
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTablePadding(new Insets(4, 10, 0, 0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setColumnWeightX(1, Double.valueOf(1.0));
        JPanel pageUI = new JPanel((LayoutManager)tableLayout);
        Property property = context.getPropertySet().getProperty(PROPERTY_KEY_WORLDMAP_TYPE);
        JComboBox<Object> box = new JComboBox<Object>();
        box.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof WorldMapLayerType && rendererComponent instanceof JLabel) {
                    WorldMapLayerType worldMapLayerType = (WorldMapLayerType)value;
                    JLabel label = (JLabel)rendererComponent;
                    label.setText(worldMapLayerType.getLabel());
                }
                return rendererComponent;
            }
        });
        box.addActionListener(e -> {
            try {
                property.setValue((Object)box.getSelectedItem().toString());
            }
            catch (ValidationException e1) {
                e1.printStackTrace();
            }
        });
        DefaultComboBoxModel<WorldMapLayerType> model = new DefaultComboBoxModel<WorldMapLayerType>(worldMapLayerTypes.toArray(new WorldMapLayerType[worldMapLayerTypes.size()]));
        box.setModel(model);
        for (WorldMapLayerType layerType : worldMapLayerTypes) {
            if (!layerType.getName().equals(property.getValue())) continue;
            box.setSelectedItem(layerType);
        }
        pageUI.add(new JLabel(property.getDescriptor().getDisplayName() + ":"));
        pageUI.add(box);
        pageUI.add(tableLayout.createVerticalSpacer());
        JPanel parent = new JPanel(new BorderLayout());
        parent.add((Component)pageUI, "Center");
        parent.add(Box.createHorizontalStrut(100), "East");
        return parent;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("layer");
    }

    static class WorldMapBean {
        @Preference(label="World Map Layer", key="worldmap.type")
        String worldMapLayerType = "BlueMarbleLayerType";

        WorldMapBean() {
        }
    }
}

