/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.preferences.layer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.Enablement;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.snap.rcp.preferences.DefaultConfigController;
import org.esa.snap.rcp.preferences.Preference;
import org.esa.snap.rcp.preferences.PreferenceUtils;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.HelpCtx;

public final class ImageLayerController
extends DefaultConfigController {
    public static final String PROPERTY_KEY_IMAGE_BG_COLOR = "image.background.color";
    public static final String PROPERTY_KEY_IMAGE_BORDER_SHOWN = "image.border.shown";
    public static final String PROPERTY_KEY_IMAGE_BORDER_SIZE = "image.border.size";
    public static final String PROPERTY_KEY_IMAGE_BORDER_COLOR = "image.border.color";
    public static final String PROPERTY_KEY_PIXEL_BORDER_SHOWN = "pixel.border.shown";
    public static final String PROPERTY_KEY_PIXEL_BORDER_SIZE = "pixel.border.size";
    public static final String PROPERTY_KEY_PIXEL_BORDER_COLOR = "pixel.border.color";
    private JComponent[] imageBorderColorComponents;
    private JComponent[] pixelBorderColorComponents;

    @Override
    protected PropertySet createPropertySet() {
        return this.createPropertySet(new ImageLayerBean());
    }

    @Override
    protected JPanel createPanel(BindingContext context) {
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTablePadding(new Insets(4, 10, 0, 0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setColumnWeightX(1, Double.valueOf(1.0));
        tableLayout.setCellColspan(1, 0, Integer.valueOf(2));
        tableLayout.setCellColspan(4, 0, Integer.valueOf(2));
        JPanel pageUI = new JPanel((LayoutManager)tableLayout);
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        Property backgroundColor = context.getPropertySet().getProperty(PROPERTY_KEY_IMAGE_BG_COLOR);
        Property showImageBorder = context.getPropertySet().getProperty(PROPERTY_KEY_IMAGE_BORDER_SHOWN);
        Property imageBorderSize = context.getPropertySet().getProperty(PROPERTY_KEY_IMAGE_BORDER_SIZE);
        Property imageBorderColor = context.getPropertySet().getProperty(PROPERTY_KEY_IMAGE_BORDER_COLOR);
        Property showPixelBorder = context.getPropertySet().getProperty(PROPERTY_KEY_PIXEL_BORDER_SHOWN);
        Property pixelBorderSize = context.getPropertySet().getProperty(PROPERTY_KEY_PIXEL_BORDER_SIZE);
        Property pixelBorderColor = context.getPropertySet().getProperty(PROPERTY_KEY_PIXEL_BORDER_COLOR);
        JComponent[] backgroundColorComponents = PreferenceUtils.createColorComponents(backgroundColor);
        JComponent[] showImageBorderComponents = registry.findPropertyEditor(showImageBorder.getDescriptor()).createComponents(showImageBorder.getDescriptor(), context);
        JComponent[] imageBorderSizeComponents = registry.findPropertyEditor(imageBorderSize.getDescriptor()).createComponents(imageBorderSize.getDescriptor(), context);
        this.imageBorderColorComponents = PreferenceUtils.createColorComponents(imageBorderColor);
        JComponent[] showPixelBorderComponents = registry.findPropertyEditor(showPixelBorder.getDescriptor()).createComponents(showPixelBorder.getDescriptor(), context);
        JComponent[] pixelBorderSizeComponents = registry.findPropertyEditor(pixelBorderSize.getDescriptor()).createComponents(pixelBorderSize.getDescriptor(), context);
        this.pixelBorderColorComponents = PreferenceUtils.createColorComponents(pixelBorderColor);
        pageUI.add(backgroundColorComponents[0]);
        pageUI.add(backgroundColorComponents[1]);
        pageUI.add(showImageBorderComponents[0]);
        pageUI.add(imageBorderSizeComponents[1]);
        pageUI.add(imageBorderSizeComponents[0]);
        pageUI.add(this.imageBorderColorComponents[0]);
        pageUI.add(this.imageBorderColorComponents[1]);
        pageUI.add(showPixelBorderComponents[0]);
        pageUI.add(pixelBorderSizeComponents[1]);
        pageUI.add(pixelBorderSizeComponents[0]);
        pageUI.add(this.pixelBorderColorComponents[0]);
        pageUI.add(this.pixelBorderColorComponents[1]);
        pageUI.add(tableLayout.createVerticalSpacer());
        JPanel parent = new JPanel(new BorderLayout());
        parent.add((Component)pageUI, "Center");
        parent.add(Box.createHorizontalStrut(100), "East");
        return parent;
    }

    @Override
    protected void configure(BindingContext context) {
        Enablement enablementImageBorderSize = context.bindEnabledState(PROPERTY_KEY_IMAGE_BORDER_SIZE, false, PROPERTY_KEY_IMAGE_BORDER_SHOWN, (Object)false);
        context.getPropertySet().getProperty(PROPERTY_KEY_IMAGE_BORDER_SHOWN).addPropertyChangeListener(evt -> {
            enablementImageBorderSize.apply();
            for (JComponent imageBorderColorComponent : this.imageBorderColorComponents) {
                imageBorderColorComponent.setEnabled((Boolean)evt.getNewValue());
            }
        });
        Enablement enablementPixelBorderSize = context.bindEnabledState(PROPERTY_KEY_PIXEL_BORDER_SIZE, false, PROPERTY_KEY_PIXEL_BORDER_SHOWN, (Object)false);
        context.getPropertySet().getProperty(PROPERTY_KEY_PIXEL_BORDER_SHOWN).addPropertyChangeListener(evt -> {
            enablementPixelBorderSize.apply();
            for (JComponent pixelBorderColorComponent : this.pixelBorderColorComponents) {
                pixelBorderColorComponent.setEnabled((Boolean)evt.getNewValue());
            }
        });
        for (JComponent imageBorderColorComponent : this.imageBorderColorComponents) {
            imageBorderColorComponent.setEnabled(false);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("layer");
    }

    static class ImageLayerBean {
        @Preference(label="Background colour", key="image.background.color")
        Color backgroundColor = ProductSceneView.DEFAULT_IMAGE_BACKGROUND_COLOR;
        @Preference(label="Show image border", key="image.border.shown")
        boolean showImageBorder = false;
        @Preference(label="Image border size", key="image.border.size")
        double imageBorderSize = 1.0;
        @Preference(label="Image border colour", key="image.border.color")
        Color imageBorderColor = ImageLayer.DEFAULT_BORDER_COLOR;
        @Preference(label="Show pixel borders in magnified views", key="pixel.border.shown")
        boolean showPixelBorder = ImageLayer.DEFAULT_PIXEL_BORDER_SHOWN;
        @Preference(label="Pixel border size", key="pixel.border.size")
        double pixelBorderSize = 0.0;
        @Preference(label="Pixel border colour", key="pixel.border.color")
        Color pixelBorderColor = ImageLayer.DEFAULT_PIXEL_BORDER_COLOR;

        ImageLayerBean() {
        }
    }
}

