/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.wms;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.util.List;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.wms.WmsLayerType;
import org.esa.snap.ui.layer.LayerSourcePageContext;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.wms.WebMapServer;

abstract class WmsWorker
extends ProgressMonitorSwingWorker<com.bc.ceres.glayer.Layer, Object> {
    private final LayerSourcePageContext context;
    private final Dimension mapImageSize;

    protected WmsWorker(LayerSourcePageContext context, Dimension mapImageSize) {
        super((Component)context.getWindow(), "WMS Access");
        this.context = context;
        this.mapImageSize = mapImageSize;
    }

    public LayerSourcePageContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected com.bc.ceres.glayer.Layer doInBackground(ProgressMonitor pm) throws Exception {
        try {
            pm.beginTask("Loading layer from WMS", -1);
            LayerType wmsType = LayerTypeRegistry.getLayerType((String)WmsLayerType.class.getName());
            PropertySet template = wmsType.createLayerConfig(this.getContext().getLayerContext());
            RasterDataNode raster = SnapApp.getDefault().getSelectedProductSceneView().getRaster();
            template.setValue("raster", (Object)raster);
            template.setValue("imageSize", (Object)this.mapImageSize);
            URL wmsUrl = (URL)this.context.getPropertyValue("wmsUrl");
            template.setValue("serverUrl", (Object)wmsUrl);
            StyleImpl selectedStyle = (StyleImpl)this.context.getPropertyValue("selectedStyle");
            String styleName = null;
            if (selectedStyle != null) {
                styleName = selectedStyle.getName();
            }
            template.setValue("styleName", (Object)styleName);
            WebMapServer wms = (WebMapServer)this.context.getPropertyValue("wms");
            List layerList = wms.getCapabilities().getLayerList();
            Layer selectedLayer = (Layer)this.context.getPropertyValue("selectedLayer");
            template.setValue("layerIndex", (Object)layerList.indexOf(selectedLayer));
            CRSEnvelope crsEnvelope = (CRSEnvelope)this.context.getPropertyValue("crsEnvelope");
            template.setValue("crsEnvelope", (Object)crsEnvelope);
            com.bc.ceres.glayer.Layer layer = wmsType.createLayer(this.getContext().getLayerContext(), template);
            layer.setName(selectedLayer.getName());
            com.bc.ceres.glayer.Layer layer2 = layer;
            return layer2;
        }
        finally {
            pm.done();
        }
    }
}

