/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.vector;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.EventListener;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.vector.AbstractImportVectorDataNodeAction;
import org.esa.snap.rcp.actions.vector.Bundle;
import org.esa.snap.rcp.actions.vector.VectorDataNodeImporter;
import org.esa.snap.rcp.layermanager.layersrc.shapefile.SLDUtils;
import org.geotools.feature.FeatureCollection;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ImportVectorDataNodeFromShapefileAction
extends AbstractImportVectorDataNodeAction
implements ContextAwareAction,
LookupListener {
    private VectorDataNodeImporter importer;
    private Lookup lookup;
    private final Lookup.Result<Product> result;
    private static final String vector_data_type = "SHAPEFILE";

    public ImportVectorDataNodeFromShapefileAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ImportVectorDataNodeFromShapefileAction(Lookup lookup) {
        this.lookup = lookup;
        this.result = lookup.lookupResult(Product.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnableState();
        this.setHelpId(Bundle.CTL_ImportVectorDataNodeFromShapefileActionHelp());
        this.putValue("Name", Bundle.CTL_ImportVectorDataNodeFromShapefileActionText());
        this.putValue("ShortDescription", Bundle.CTL_ImportVectorDataNodeFromShapefileActionDescription());
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ImportVectorDataNodeFromShapefileAction(lookup);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnableState();
    }

    private void setEnableState() {
        boolean state = false;
        ProductNode productNode = (ProductNode)this.lookup.lookup(ProductNode.class);
        if (productNode != null) {
            Product product = productNode.getProduct();
            state = product != null && product.getSceneGeoCoding() != null;
        }
        this.setEnabled(state);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        SnapFileFilter filter = new SnapFileFilter(this.getVectorDataType(), new String[]{".shp"}, "ESRI Shapefiles");
        this.importer = new VectorDataNodeImporter(this.getHelpId(), filter, new VdnShapefileReader(), "Import Shapefile", "shape.io.dir");
        this.importer.importGeometry(SnapApp.getDefault());
    }

    @Override
    protected String getDialogTitle() {
        return this.importer.getDialogTitle();
    }

    @Override
    protected String getVectorDataType() {
        return vector_data_type;
    }

    class VdnShapefileReader
    implements VectorDataNodeImporter.VectorDataNodeReader {
        VdnShapefileReader() {
        }

        @Override
        public VectorDataNode readVectorDataNode(File file, Product product, ProgressMonitor pm) throws IOException {
            FeatureCollection featureCollection = FeatureUtils.loadShapefileForProduct((File)file, (Product)product, (FeatureUtils.FeatureCrsProvider)ImportVectorDataNodeFromShapefileAction.this.crsProvider, (ProgressMonitor)pm);
            Style[] styles = SLDUtils.loadSLD(file);
            ProductNodeGroup vectorDataGroup = product.getVectorDataGroup();
            String name = VectorDataNodeImporter.findUniqueVectorDataNodeName(((SimpleFeatureType)featureCollection.getSchema()).getName().getLocalPart(), (ProductNodeGroup<VectorDataNode>)vectorDataGroup);
            if (styles.length > 0) {
                SimpleFeatureType featureType = SLDUtils.createStyledFeatureType((SimpleFeatureType)featureCollection.getSchema());
                VectorDataNode vectorDataNode = new VectorDataNode(name, featureType);
                FeatureCollection styledCollection = vectorDataNode.getFeatureCollection();
                String defaultCSS = vectorDataNode.getDefaultStyleCss();
                SLDUtils.applyStyle(styles[0], defaultCSS, (FeatureCollection<SimpleFeatureType, SimpleFeature>)featureCollection, (FeatureCollection<SimpleFeatureType, SimpleFeature>)styledCollection);
                return vectorDataNode;
            }
            return new VectorDataNode(name, featureCollection);
        }
    }
}

