/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file.export;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.ImageLegend;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.param.ParamGroup;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.export.AbstractExportImageAction;
import org.esa.snap.rcp.actions.file.export.Bundle;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ExportLegendImageAction
extends AbstractExportImageAction {
    private static final String[][] IMAGE_FORMAT_DESCRIPTIONS = new String[][]{BMP_FORMAT_DESCRIPTION, PNG_FORMAT_DESCRIPTION, JPEG_FORMAT_DESCRIPTION, TIFF_FORMAT_DESCRIPTION};
    private static final String HELP_ID = "exportLegendImageFile";
    private static final String HORIZONTAL_STR = "Horizontal";
    private static final String VERTICAL_STR = "Vertical";
    private SnapFileFilter[] imageFileFilters;
    private ParamGroup legendParamGroup;
    private ImageLegend imageLegend;
    private Lookup.Result<ProductSceneView> result;

    public ExportLegendImageAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ExportLegendImageAction(Lookup lookup) {
        super(Bundle.CTL_ExportLegendImageAction_MenuText(), HELP_ID);
        this.putValue("popupText", Bundle.CTL_ExportLegendImageAction_PopupText());
        this.imageFileFilters = new SnapFileFilter[IMAGE_FORMAT_DESCRIPTIONS.length];
        for (int i = 0; i < IMAGE_FORMAT_DESCRIPTIONS.length; ++i) {
            this.imageFileFilters[i] = ExportLegendImageAction.createFileFilter(IMAGE_FORMAT_DESCRIPTIONS[i]);
        }
        this.result = lookup.lookupResult(ProductSceneView.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnabled(false);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ExportLegendImageAction(lookup);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.exportImage(this.imageFileFilters);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        boolean enabled = view != null && !view.isRGB();
        this.setEnabled(enabled);
    }

    @Override
    protected void configureFileChooser(SnapFileChooser fileChooser, ProductSceneView view, String imageBaseName) {
        this.legendParamGroup = ExportLegendImageAction.createLegendParamGroup();
        this.legendParamGroup.setParameterValues(SnapApp.getDefault().getPreferencesPropertyMap(), null);
        ExportLegendImageAction.modifyHeaderText(this.legendParamGroup, view.getRaster());
        fileChooser.setDialogTitle(SnapApp.getDefault().getInstanceName() + " - export Colour Legend Image");
        fileChooser.setCurrentFilename(imageBaseName + "_legend");
        RasterDataNode raster = view.getRaster();
        this.imageLegend = new ImageLegend(raster.getImageInfo(), raster);
        fileChooser.setAccessory(ExportLegendImageAction.createImageLegendAccessory((JFileChooser)fileChooser, this.legendParamGroup, this.imageLegend, this.getHelpCtx().getHelpID()));
    }

    @Override
    protected RenderedImage createImage(String imageFormat, ProductSceneView view) {
        ExportLegendImageAction.transferParamsToImageLegend(this.legendParamGroup, this.imageLegend);
        this.imageLegend.setBackgroundTransparencyEnabled(ExportLegendImageAction.isTransparencySupportedByFormat(imageFormat));
        return this.imageLegend.createImage();
    }

    @Override
    protected boolean isEntireImageSelected() {
        return true;
    }

    private static ParamGroup createLegendParamGroup() {
        ParamGroup paramGroup = new ParamGroup();
        Parameter param = new Parameter("legend.usingHeader", (Object)Boolean.TRUE);
        param.getProperties().setLabel("Show header text");
        paramGroup.addParameter(param);
        param = new Parameter("legend.headerText", (Object)"");
        param.getProperties().setLabel("Header text");
        param.getProperties().setNumCols(24);
        param.getProperties().setNullValueAllowed(true);
        paramGroup.addParameter(param);
        param = new Parameter("legend.orientation", (Object)HORIZONTAL_STR);
        param.getProperties().setLabel("Orientation");
        param.getProperties().setValueSet(new String[]{HORIZONTAL_STR, VERTICAL_STR});
        param.getProperties().setValueSetBound(true);
        paramGroup.addParameter(param);
        param = new Parameter("legend.fontSize", (Object)14);
        param.getProperties().setLabel("Font size");
        param.getProperties().setMinValue((Number)4);
        param.getProperties().setMaxValue((Number)100);
        paramGroup.addParameter(param);
        param = new Parameter("legend.foregroundColor", (Object)Color.black);
        param.getProperties().setLabel("Foreground colour");
        paramGroup.addParameter(param);
        param = new Parameter("legend.backgroundColor", (Object)Color.white);
        param.getProperties().setLabel("Background colour");
        paramGroup.addParameter(param);
        param = new Parameter("legend.backgroundTransparency", (Object)Float.valueOf(0.0f));
        param.getProperties().setLabel("Background transparency");
        param.getProperties().setMinValue((Number)Float.valueOf(0.0f));
        param.getProperties().setMaxValue((Number)Float.valueOf(1.0f));
        paramGroup.addParameter(param);
        param = new Parameter("legend.antialiasing", (Object)Boolean.TRUE);
        param.getProperties().setLabel("Perform anti-aliasing");
        paramGroup.addParameter(param);
        return paramGroup;
    }

    private static void modifyHeaderText(ParamGroup legendParamGroup, RasterDataNode raster) {
        String name = raster.getName();
        String unit = raster.getUnit() != null ? raster.getUnit() : "-";
        unit = unit.replace('*', ' ');
        String headerText = name + " [" + unit + "]";
        legendParamGroup.getParameter("legend.headerText").setValue((Object)headerText, null);
    }

    private static JComponent createImageLegendAccessory(JFileChooser fileChooser, ParamGroup legendParamGroup, ImageLegend imageLegend, String helpId) {
        JButton button = new JButton("Properties...");
        button.setMnemonic('P');
        button.addActionListener(e -> {
            SnapFileFilter fileFilter = (SnapFileFilter)fileChooser.getFileFilter();
            ImageLegendDialog dialog = new ImageLegendDialog(legendParamGroup, imageLegend, ExportLegendImageAction.isTransparencySupportedByFormat(fileFilter.getFormatName()), helpId);
            dialog.show();
        });
        JPanel accessory = new JPanel(new BorderLayout());
        accessory.setBorder(new EmptyBorder(3, 3, 3, 3));
        accessory.add((Component)button, "North");
        return accessory;
    }

    private static void transferParamsToImageLegend(ParamGroup legendParamGroup, ImageLegend imageLegend) {
        Object value = legendParamGroup.getParameter("legend.usingHeader").getValue();
        imageLegend.setUsingHeader(((Boolean)value).booleanValue());
        value = legendParamGroup.getParameter("legend.headerText").getValue();
        imageLegend.setHeaderText((String)value);
        value = legendParamGroup.getParameter("legend.orientation").getValue();
        imageLegend.setOrientation(HORIZONTAL_STR.equals(value) ? 0 : 1);
        value = legendParamGroup.getParameter("legend.fontSize").getValue();
        imageLegend.setFont(imageLegend.getFont().deriveFont(((Number)value).floatValue()));
        value = legendParamGroup.getParameter("legend.backgroundColor").getValue();
        imageLegend.setBackgroundColor((Color)value);
        value = legendParamGroup.getParameter("legend.foregroundColor").getValue();
        imageLegend.setForegroundColor((Color)value);
        value = legendParamGroup.getParameter("legend.backgroundTransparency").getValue();
        imageLegend.setBackgroundTransparency(((Number)value).floatValue());
        value = legendParamGroup.getParameter("legend.antialiasing").getValue();
        imageLegend.setAntialiasing(((Boolean)value).booleanValue());
    }

    public static class ImageLegendDialog
    extends ModalDialog {
        private ImageInfo imageInfo;
        private RasterDataNode raster;
        private boolean transparencyEnabled;
        private ParamGroup paramGroup;
        private Parameter usingHeaderParam;
        private Parameter headerTextParam;
        private Parameter orientationParam;
        private Parameter fontSizeParam;
        private Parameter backgroundColorParam;
        private Parameter foregroundColorParam;
        private Parameter antialiasingParam;
        private Parameter backgroundTransparencyParam;

        public ImageLegendDialog(ParamGroup paramGroup, ImageLegend imageLegend, boolean transparencyEnabled, String helpId) {
            super((Window)SnapApp.getDefault().getMainFrame(), SnapApp.getDefault().getInstanceName() + " - Colour Legend Properties", 33, helpId);
            this.imageInfo = imageLegend.getImageInfo();
            this.raster = imageLegend.getRaster();
            this.transparencyEnabled = transparencyEnabled;
            this.paramGroup = paramGroup;
            this.initParams();
            this.initUI();
            this.updateUIState();
            this.paramGroup.addParamChangeListener(event -> this.updateUIState());
        }

        private void updateUIState() {
            boolean headerTextEnabled = (Boolean)this.usingHeaderParam.getValue();
            this.headerTextParam.setUIEnabled(headerTextEnabled);
            this.backgroundTransparencyParam.setUIEnabled(this.transparencyEnabled);
        }

        public ParamGroup getParamGroup() {
            return this.paramGroup;
        }

        public void getImageLegend(ImageLegend imageLegend) {
            ExportLegendImageAction.transferParamsToImageLegend(this.getParamGroup(), imageLegend);
        }

        public ImageInfo getImageInfo() {
            return this.imageInfo;
        }

        protected void onOK() {
            this.getParamGroup().getParameterValues(SnapApp.getDefault().getPreferencesPropertyMap());
            super.onOK();
        }

        private void initUI() {
            JButton previewButton = new JButton("Preview...");
            previewButton.setMnemonic('v');
            previewButton.addActionListener(e -> this.showPreview());
            GridBagConstraints gbc = new GridBagConstraints();
            JPanel p = GridBagUtils.createPanel();
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets.top = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            p.add((Component)this.usingHeaderParam.getEditor().getEditorComponent(), gbc);
            ++gbc.gridy;
            gbc.gridwidth = 1;
            p.add((Component)this.headerTextParam.getEditor().getLabelComponent(), gbc);
            p.add((Component)this.headerTextParam.getEditor().getEditorComponent(), gbc);
            ++gbc.gridy;
            gbc.insets.top = 10;
            p.add((Component)this.orientationParam.getEditor().getLabelComponent(), gbc);
            p.add((Component)this.orientationParam.getEditor().getEditorComponent(), gbc);
            ++gbc.gridy;
            gbc.insets.top = 3;
            p.add((Component)this.fontSizeParam.getEditor().getLabelComponent(), gbc);
            p.add((Component)this.fontSizeParam.getEditor().getEditorComponent(), gbc);
            ++gbc.gridy;
            gbc.insets.top = 10;
            p.add((Component)this.foregroundColorParam.getEditor().getLabelComponent(), gbc);
            p.add((Component)this.foregroundColorParam.getEditor().getEditorComponent(), gbc);
            ++gbc.gridy;
            gbc.insets.top = 3;
            p.add((Component)this.backgroundColorParam.getEditor().getLabelComponent(), gbc);
            p.add((Component)this.backgroundColorParam.getEditor().getEditorComponent(), gbc);
            ++gbc.gridy;
            gbc.insets.top = 3;
            p.add((Component)this.backgroundTransparencyParam.getEditor().getLabelComponent(), gbc);
            p.add((Component)this.backgroundTransparencyParam.getEditor().getEditorComponent(), gbc);
            ++gbc.gridy;
            gbc.insets.top = 10;
            gbc.gridx = 0;
            gbc.anchor = 18;
            p.add((Component)this.antialiasingParam.getEditor().getEditorComponent(), gbc);
            gbc.insets.top = 10;
            gbc.gridx = 1;
            gbc.anchor = 12;
            p.add((Component)previewButton, gbc);
            p.setBorder(new EmptyBorder(7, 7, 7, 7));
            this.setContent(p);
        }

        private void initParams() {
            this.usingHeaderParam = this.paramGroup.getParameter("legend.usingHeader");
            this.headerTextParam = this.paramGroup.getParameter("legend.headerText");
            this.orientationParam = this.paramGroup.getParameter("legend.orientation");
            this.fontSizeParam = this.paramGroup.getParameter("legend.fontSize");
            this.foregroundColorParam = this.paramGroup.getParameter("legend.foregroundColor");
            this.backgroundColorParam = this.paramGroup.getParameter("legend.backgroundColor");
            this.backgroundTransparencyParam = this.paramGroup.getParameter("legend.backgroundTransparency");
            this.antialiasingParam = this.paramGroup.getParameter("legend.antialiasing");
        }

        private void showPreview() {
            ImageLegend imageLegend = new ImageLegend(this.getImageInfo(), this.raster);
            this.getImageLegend(imageLegend);
            final BufferedImage image = imageLegend.createImage();
            final JLabel imageDisplay = new JLabel(new ImageIcon(image));
            imageDisplay.setOpaque(true);
            imageDisplay.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    ImageLegendDialog.showPopup(e, image, imageDisplay);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }
            });
            ModalDialog dialog = new ModalDialog(this.getParent(), SnapApp.getDefault().getInstanceName() + " - Colour Legend Preview", (Object)imageDisplay, 1, null);
            dialog.getJDialog().setResizable(false);
            dialog.show();
        }

        private static void showPopup(MouseEvent e, BufferedImage image, JComponent imageDisplay) {
            if (e.isPopupTrigger()) {
                JPopupMenu popupMenu = new JPopupMenu();
                JMenuItem menuItem = new JMenuItem("Copy image to clipboard");
                menuItem.addActionListener(e1 -> SystemUtils.copyToClipboard((Image)image));
                popupMenu.add(menuItem);
                popupMenu.show(imageDisplay, e.getX(), e.getY());
            }
        }
    }
}

