/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.smart.configurator.DiskBenchmarker;
import org.esa.snap.smart.configurator.SystemInfos;

public class JavaSystemInfos
implements SystemInfos {
    private String[] diskNames = null;
    private Map<String, DiskBenchmarker> disksBenchMarkers = null;
    private int benchmarkFileSize = 0;
    private int benchmarkNbSamples = 0;
    private static JavaSystemInfos systemInfos = null;

    private JavaSystemInfos(int benchmarkFileSize, int benchmarkNbSamples) {
        this.benchmarkNbSamples = benchmarkNbSamples;
        this.benchmarkFileSize = benchmarkFileSize;
        this.updateSystemInfos();
    }

    public static JavaSystemInfos getInstance() {
        if (systemInfos == null) {
            systemInfos = new JavaSystemInfos(5, 4);
        }
        return systemInfos;
    }

    public static JavaSystemInfos getInstance(int benchmarkFileSize, int benchmarkNbSamples) {
        if (systemInfos == null) {
            systemInfos = new JavaSystemInfos(benchmarkFileSize, benchmarkNbSamples);
        }
        return systemInfos;
    }

    private void updateSystemInfos() {
        this.diskNames = this.getDisksNames();
        this.disksBenchMarkers = new HashMap<String, DiskBenchmarker>();
        for (String diskName : this.diskNames) {
            DiskBenchmarker benchmarker = new DiskBenchmarker(diskName, this.benchmarkFileSize, this.benchmarkNbSamples);
            this.disksBenchMarkers.put(diskName, benchmarker);
        }
    }

    @Override
    public int getNbCPUs() {
        int nbCPUs = Runtime.getRuntime().availableProcessors();
        SystemUtils.LOG.fine("NB CPUs: " + nbCPUs);
        return nbCPUs;
    }

    @Override
    public long getRAM() {
        OperatingSystemMXBean mXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long totalRAMInByte = mXBean.getTotalPhysicalMemorySize();
        long totalRAMInMB = Math.round((double)totalRAMInByte / 1000000.0);
        SystemUtils.LOG.fine("Total RAM in MB: " + totalRAMInMB);
        return totalRAMInMB;
    }

    @Override
    public long getFreeRAM() {
        OperatingSystemMXBean mXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long freeRAMInByte = mXBean.getFreePhysicalMemorySize();
        long freeRamInMegaBytes = Math.round(freeRAMInByte / 0x100000L);
        SystemUtils.LOG.fine("Free RAM in MB: " + freeRamInMegaBytes);
        return freeRamInMegaBytes;
    }

    @Override
    public long getReservedRam() {
        long reservedRAMInBytes = Runtime.getRuntime().totalMemory();
        long reservedRAMInMB = Math.round(reservedRAMInBytes / 0x100000L);
        SystemUtils.LOG.fine("RAM reserved by SNAP in MB: " + reservedRAMInMB);
        return reservedRAMInMB;
    }

    @Override
    public String[] getDisksNames() {
        if (this.diskNames == null) {
            Iterable<Path> fileSystemsIterable = FileSystems.getDefault().getRootDirectories();
            Vector<String> driveNames = new Vector<String>();
            for (Path path : fileSystemsIterable) {
                driveNames.add(path.toString());
            }
            String[] driveNamesArray = new String[driveNames.size()];
            this.diskNames = driveNames.toArray(driveNamesArray);
        }
        return this.diskNames;
    }

    @Override
    public long getDiskFreeSize(String diskId) {
        File thisDisk = new File(diskId);
        long diskFreeSpaceInBytes = thisDisk.getFreeSpace();
        return Math.round(diskFreeSpaceInBytes / 0x100000L);
    }

    @Override
    public double getDiskWriteSpeed(String diskId) throws IOException {
        return this.disksBenchMarkers.get(diskId).getWriteSpeed();
    }

    @Override
    public double getDiskReadSpeed(String diskId) throws IOException {
        return this.disksBenchMarkers.get(diskId).getReadSpeed();
    }
}

