/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.worldwind.layers;

import com.bc.ceres.core.Assert;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.worldwind.layers.DefaultWWLayerDescriptor;
import org.esa.snap.worldwind.layers.WWLayer;
import org.esa.snap.worldwind.layers.WWLayerDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;

public class WWLayerRegistry {
    private static WWLayerRegistry instance = null;
    private final Map<String, WWLayerDescriptor> wwLayerDescriptors = new HashMap<String, WWLayerDescriptor>();

    public WWLayerRegistry() {
        this.registerWWLayers();
    }

    public static WWLayerRegistry getInstance() {
        if (instance == null) {
            instance = new WWLayerRegistry();
        }
        return instance;
    }

    public WWLayerDescriptor[] getWWLayerDescriptors() {
        return this.wwLayerDescriptors.values().toArray(new WWLayerDescriptor[this.wwLayerDescriptors.values().size()]);
    }

    private void registerWWLayers() {
        FileObject fileObj = FileUtil.getConfigFile((String)"WorldWindLayers");
        if (fileObj == null) {
            SystemUtils.LOG.warning("No World Wind layers found.");
            return;
        }
        FileObject[] files = fileObj.getChildren();
        List orderedFiles = FileUtil.getOrder(Arrays.asList(files), (boolean)true);
        for (FileObject file : orderedFiles) {
            WWLayerDescriptor WWLayerDescriptor2 = null;
            try {
                WWLayerDescriptor2 = WWLayerRegistry.createWWLayerDescriptor(file);
            }
            catch (Exception e) {
                SystemUtils.LOG.severe(String.format("Failed to create WWLayerDescriptor from layer.xml path '%s'", file.getPath()));
            }
            if (WWLayerDescriptor2 == null) continue;
            WWLayerDescriptor existingDescriptor = this.wwLayerDescriptors.get(WWLayerDescriptor2.getId());
            if (existingDescriptor != null) {
                SystemUtils.LOG.warning(String.format("WWLayer [%s] has been redeclared!\n", WWLayerDescriptor2.getId()));
            }
            this.wwLayerDescriptors.put(WWLayerDescriptor2.getId(), WWLayerDescriptor2);
            SystemUtils.LOG.fine(String.format("New WWLayer added from layer.xml path '%s': %s", file.getPath(), WWLayerDescriptor2.getId()));
        }
    }

    public static WWLayerDescriptor createWWLayerDescriptor(FileObject fileObject) {
        String id = fileObject.getName();
        String showInWorldMapToolView = (String)fileObject.getAttribute("showInWorldMapToolView");
        String showIn3DToolView = (String)fileObject.getAttribute("showIn3DToolView");
        Class<WWLayer> WWLayerClass = WWLayerRegistry.getClassAttribute(fileObject, "WWLayerClass", WWLayer.class, false);
        Assert.argument((showInWorldMapToolView != null && (showInWorldMapToolView.equalsIgnoreCase("true") || showInWorldMapToolView.equalsIgnoreCase("false")) ? 1 : 0) != 0, (String)"Missing attribute 'showInWorldMapToolView'");
        Assert.argument((showIn3DToolView != null && (showIn3DToolView.equalsIgnoreCase("true") || showIn3DToolView.equalsIgnoreCase("false")) ? 1 : 0) != 0, (String)"Missing attribute 'showIn3DToolView'");
        Assert.argument((WWLayerClass != null ? 1 : 0) != 0, (String)"Attribute 'class' must be provided");
        return new DefaultWWLayerDescriptor(id, Boolean.parseBoolean(showInWorldMapToolView), Boolean.parseBoolean(showIn3DToolView), WWLayerClass);
    }

    public static <T> Class<T> getClassAttribute(FileObject fileObject, String attributeName, Class<T> expectedType, boolean required) {
        String className = (String)fileObject.getAttribute(attributeName);
        if (className == null || className.isEmpty()) {
            if (required) {
                throw new IllegalArgumentException(String.format("Missing attribute '%s' of type %s", attributeName, expectedType.getName()));
            }
            return null;
        }
        Collection modules = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (ModuleInfo module : modules) {
            if (!module.isEnabled()) continue;
            try {
                Class<?> implClass = module.getClassLoader().loadClass(className);
                if (expectedType.isAssignableFrom(implClass)) {
                    return implClass;
                }
                throw new IllegalArgumentException(String.format("Value %s of attribute '%s' must be a %s", implClass.getName(), attributeName, expectedType.getName()));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }
}

