/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.worldwind;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.util.Logging;
import java.awt.Dimension;
import java.util.logging.Level;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.runtime.Config;
import org.esa.snap.worldwind.AppPanel;
import org.esa.snap.worldwind.WWWorldViewToolView;
import org.esa.snap.worldwind.layers.WWLayer;
import org.openide.windows.WindowManager;

public abstract class WWBaseToolView
extends ToolTopComponent {
    private static final String WORLDWIND_LOGLEVEL_KEY = "snap.worldwind.logLevel";
    private final Dimension canvasSize = new Dimension(800, 600);
    protected AppPanel wwjPanel = null;
    private Position eyePosition = null;

    public WWBaseToolView() {
        this.initWWLogging();
    }

    AppPanel createWWPanel(WorldWindowGLCanvas shareWith, boolean includeStatusBar, boolean flatWorld, boolean removeExtraLayers) {
        this.wwjPanel = new AppPanel(shareWith, includeStatusBar, flatWorld, removeExtraLayers);
        this.wwjPanel.setPreferredSize(this.canvasSize);
        return this.wwjPanel;
    }

    WorldWindowGLCanvas getWwd() {
        if (this.wwjPanel == null) {
            return null;
        }
        return this.wwjPanel.getWwd();
    }

    protected WorldWindowGLCanvas findWorldWindView() {
        WWWorldViewToolView window = (WWWorldViewToolView)WindowManager.getDefault().findTopComponent("WWWorldMapToolView");
        if (window != null) {
            return window.getWwd();
        }
        return null;
    }

    public Product getSelectedProduct() {
        LayerList layerList = this.getWwd().getModel().getLayers();
        for (Layer layer : layerList) {
            if (!(layer instanceof WWLayer)) continue;
            WWLayer wwLayer = (WWLayer)layer;
            return wwLayer.getSelectedProduct();
        }
        return null;
    }

    private void gotoProduct(Product product) {
        if (product == null) {
            return;
        }
        View theView = this.getWwd().getView();
        Position origPos = theView.getEyePosition();
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (geoCoding != null && origPos != null) {
            GeoPos centre = product.getSceneGeoCoding().getGeoPos(new PixelPos((double)(product.getSceneRasterWidth() / 2), (double)(product.getSceneRasterHeight() / 2)), null);
            centre.normalize();
            theView.setEyePosition(Position.fromDegrees(centre.getLat(), centre.getLon(), origPos.getElevation()));
        }
    }

    public void setSelectedProduct(Product product) {
        if (product == this.getSelectedProduct() && this.eyePosition == this.getWwd().getView().getEyePosition()) {
            return;
        }
        LayerList layerList = this.getWwd().getModel().getLayers();
        layerList.stream().filter(layer -> layer instanceof WWLayer).forEach(layer -> {
            WWLayer wwLayer = (WWLayer)layer;
            wwLayer.setSelectedProduct(product);
        });
        if (this.isVisible()) {
            this.gotoProduct(product);
            this.getWwd().redrawNow();
            this.eyePosition = this.getWwd().getView().getEyePosition();
        }
    }

    public void setProducts(Product[] products) {
        WorldWindowGLCanvas wwd = this.getWwd();
        LayerList layerList = this.getWwd().getModel().getLayers();
        layerList.stream().filter(layer -> layer instanceof WWLayer).forEach(layer -> {
            WWLayer wwLayer = (WWLayer)layer;
            for (Product prod : products) {
                try {
                    wwLayer.addProduct(prod, wwd);
                }
                catch (Exception e) {
                    SnapApp.getDefault().handleError("WorldWind unable to add product " + prod.getName(), (Throwable)e);
                }
            }
        });
    }

    public void removeProduct(Product product) {
        if (this.getSelectedProduct() == product) {
            this.setSelectedProduct(null);
        }
        LayerList layerList = this.getWwd().getModel().getLayers();
        layerList.stream().filter(layer -> layer instanceof WWLayer).forEach(layer -> {
            WWLayer wwLayer = (WWLayer)layer;
            wwLayer.removeProduct(product);
        });
        if (this.isVisible()) {
            this.getWwd().redrawNow();
        }
    }

    private void initWWLogging() {
        String level = Config.instance().preferences().get(WORLDWIND_LOGLEVEL_KEY, "OFF");
        Logging.logger().setLevel(Level.parse(level));
    }
}

