/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff.internal;

import org.esa.snap.dataio.geotiff.internal.TiffShort;

class TiffCode {
    public static final int COMPRESSION_UNCOMPRESSED = 1;
    public static final int COMPRESSION_CCITT_1D = 2;
    public static final int COMPRESSION_GROUP3_FAX = 3;
    public static final int COMPRESSION_GROUP4_FAX = 4;
    public static final int COMPRESSION_LZW = 5;
    public static final int COMPRESSION_PACKBITS = 32773;
    public static final TiffShort PHOTOMETRIC_WHITE_IS_ZERO = new TiffShort(0);
    public static final TiffShort PHOTOMETRIC_BLACK_IS_ZERO = new TiffShort(1);
    public static final TiffShort PHOTOMETRIC_RGB = new TiffShort(2);
    public static final TiffShort PHOTOMETRIC_RGB_PALETTE = new TiffShort(3);
    public static final TiffShort PHOTOMETRIC_TRANSPARENCY_MASK = new TiffShort(4);
    public static final TiffShort PHOTOMETRIC_CMYK = new TiffShort(5);
    public static final TiffShort PHOTOMETRIC_YCBCR = new TiffShort(6);
    public static final TiffShort PHOTOMETRIC_CIELAB = new TiffShort(8);
    public static final short RESOLUTION_UNIT_NONE = 1;
    public static final short RESOLUTION_UNIT_INCH = 2;
    public static final short RESOLUTION_UNIT_CENTIMETER = 3;
    public static final TiffShort SAMPLE_FORMAT_UINT = new TiffShort(1);
    public static final TiffShort SAMPLE_FORMAT_INT = new TiffShort(2);
    public static final TiffShort SAMPLE_FORMAT_FLOAT = new TiffShort(3);
    public static final TiffShort SAMPLE_FORMAT_UNDEFINED = new TiffShort(4);
    public static final TiffShort PLANAR_CONFIG_CHUNKY = new TiffShort(1);
    public static final TiffShort PLANAR_CONFIG_PLANAR = new TiffShort(2);
    public static final TiffShort EXTRA_SAMPLES_UNSPEC_DATA = new TiffShort(0);
    public static final TiffShort EXTRA_SAMPLES_ASSOC_ALPHA_DATA = new TiffShort(1);
    public static final TiffShort EXTRA_SAMPLES_UNASSOC_ALPHA_DATA = new TiffShort(2);

    TiffCode() {
    }

    public static TiffShort getSampleFormat(TiffShort tiffType) {
        switch (tiffType.getValue()) {
            case 6: 
            case 8: 
            case 9: {
                return SAMPLE_FORMAT_INT;
            }
            case 1: 
            case 3: 
            case 4: {
                return SAMPLE_FORMAT_UINT;
            }
            case 11: 
            case 12: {
                return SAMPLE_FORMAT_FLOAT;
            }
            case 7: {
                return SAMPLE_FORMAT_UNDEFINED;
            }
        }
        throw new IllegalArgumentException("unknown tiffType");
    }
}

