/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.validators.NotNullValidator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;

public class TargetProductSelectorModel {
    public static final String PROPERTY_PRODUCT_NAME = "productName";
    public static final String PROPERTY_SAVE_TO_FILE_SELECTED = "saveToFileSelected";
    public static final String PROEPRTY_OPEN_IN_APP_SELECTED = "openInAppSelected";
    public static final String PROPERTY_PRODUCT_DIR = "productDir";
    public static final String PROPERTY_FORMAT_NAME = "formatName";
    private static final String ENVISAT_FORMAT_NAME = "ENVISAT";
    private String productName;
    private boolean saveToFileSelected;
    private boolean openInAppSelected;
    private File productDir;
    private String formatName;
    private String[] formatNames;
    private final PropertyContainer propertyContainer = PropertyContainer.createObjectBacked((Object)this);

    public TargetProductSelectorModel() {
        this(ProductIOPlugInManager.getInstance().getAllProductWriterFormatStrings());
    }

    public TargetProductSelectorModel(String[] formatNames) {
        PropertyDescriptor productNameDescriptor = this.propertyContainer.getDescriptor(PROPERTY_PRODUCT_NAME);
        productNameDescriptor.setValidator((Validator)new ProductNameValidator());
        productNameDescriptor.setDisplayName("target product name");
        PropertyDescriptor productDirDescriptor = this.propertyContainer.getDescriptor(PROPERTY_PRODUCT_DIR);
        productDirDescriptor.setValidator((Validator)new NotNullValidator());
        productDirDescriptor.setDisplayName("target product directory");
        this.setOpenInAppSelected(true);
        this.setSaveToFileSelected(true);
        this.formatNames = formatNames;
        if (StringUtils.contains((String[])this.formatNames, (String)"BEAM-DIMAP")) {
            this.setFormatName("BEAM-DIMAP");
        } else {
            this.setFormatName(formatNames[0]);
        }
        this.propertyContainer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName;
                switch (propertyName = evt.getPropertyName()) {
                    case "saveToFileSelected": {
                        boolean changesToDeselected;
                        boolean bl = changesToDeselected = (Boolean)evt.getNewValue() == false;
                        if (changesToDeselected) {
                            TargetProductSelectorModel.this.setOpenInAppSelected(true);
                            break;
                        }
                        if (TargetProductSelectorModel.this.canReadOutputFormat()) break;
                        TargetProductSelectorModel.this.setOpenInAppSelected(false);
                        break;
                    }
                    case "openInAppSelected": {
                        boolean changesToDeselected;
                        boolean bl = changesToDeselected = (Boolean)evt.getNewValue() == false;
                        if (!changesToDeselected) break;
                        TargetProductSelectorModel.this.setSaveToFileSelected(true);
                        break;
                    }
                    case "formatName": {
                        if (TargetProductSelectorModel.this.canReadOutputFormat()) break;
                        TargetProductSelectorModel.this.setOpenInAppSelected(false);
                    }
                }
            }
        });
    }

    public static TargetProductSelectorModel createEnvisatTargetProductSelectorModel() {
        return new EnvisatTargetProductSelectorModel();
    }

    public String getProductName() {
        return this.productName;
    }

    public boolean isSaveToFileSelected() {
        return this.saveToFileSelected;
    }

    public boolean isOpenInAppSelected() {
        return this.openInAppSelected;
    }

    public File getProductDir() {
        return this.productDir;
    }

    public File getProductFile() {
        return new File(this.productDir, this.getProductFileName());
    }

    String getProductFileName() {
        String productFileName = this.productName;
        Iterator iterator = ProductIOPlugInManager.getInstance().getWriterPlugIns(this.formatName);
        if (iterator.hasNext()) {
            ProductWriterPlugIn writerPlugIn = (ProductWriterPlugIn)iterator.next();
            boolean ok = false;
            for (String extension : writerPlugIn.getDefaultFileExtensions()) {
                if (!productFileName.endsWith(extension)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                productFileName = productFileName.concat(writerPlugIn.getDefaultFileExtensions()[0]);
            }
        }
        return productFileName;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public String[] getFormatNames() {
        return this.formatNames;
    }

    public boolean canReadOutputFormat() {
        return ProductIOPlugInManager.getInstance().getReaderPlugIns(this.formatName).hasNext();
    }

    public void setProductName(String productName) {
        this.setPropertyContainerValue(PROPERTY_PRODUCT_NAME, productName);
    }

    public void setSaveToFileSelected(boolean saveToFileSelected) {
        this.setPropertyContainerValue(PROPERTY_SAVE_TO_FILE_SELECTED, saveToFileSelected);
    }

    public void setOpenInAppSelected(boolean openInAppSelected) {
        this.setPropertyContainerValue(PROEPRTY_OPEN_IN_APP_SELECTED, openInAppSelected);
    }

    public void setProductDir(File productDir) {
        this.setPropertyContainerValue(PROPERTY_PRODUCT_DIR, productDir);
    }

    public void setFormatName(String formatName) {
        this.setPropertyContainerValue(PROPERTY_FORMAT_NAME, formatName);
    }

    public PropertyContainer getValueContainer() {
        return this.propertyContainer;
    }

    private void setPropertyContainerValue(String name, Object value) {
        this.propertyContainer.setValue(name, value);
    }

    public static class EnvisatTargetProductSelectorModel
    extends TargetProductSelectorModel {
        private EnvisatTargetProductSelectorModel() {
            super(EnvisatTargetProductSelectorModel.createFormats());
        }

        @Override
        public File getProductFile() {
            if (!TargetProductSelectorModel.ENVISAT_FORMAT_NAME.equals(this.getFormatName())) {
                return super.getProductFile();
            }
            String productName = this.getProductName();
            return new File(this.getProductDir(), FileUtils.ensureExtension((String)productName, (String)".N1"));
        }

        private static String[] createFormats() {
            String[] productWriterFormatStrings = ProductIOPlugInManager.getInstance().getAllProductWriterFormatStrings();
            String[] formatNames = Arrays.copyOf(productWriterFormatStrings, productWriterFormatStrings.length + 1);
            formatNames[formatNames.length - 1] = TargetProductSelectorModel.ENVISAT_FORMAT_NAME;
            return formatNames;
        }
    }

    private static class ProductNameValidator
    implements Validator {
        private ProductNameValidator() {
        }

        public void validateValue(Property property, Object value) throws ValidationException {
            String name = (String)value;
            if (!ProductNode.isValidNodeName((String)name)) {
                String message = MessageFormat.format("The product name ''{0}'' is not valid.\n\nNames must not start with a dot and must not\ncontain any of the following characters: \\/:*?\"<>|", name);
                throw new ValidationException(message);
            }
        }
    }
}

